<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


// Route::get('nepaltour/{slug}', array('as' => 'slug', 'uses' => 'frontend\TripsController@getDetail'));
Route::get('category/{slug}', array('as' => 'slug', 'uses' => 'frontend\TripsController@getCategory'));

Route::get('trip/{slug}', array('as' => 'slug', 'uses' => 'frontend\TripsController@getDetail'));
Route::post('trip/{slug}', array('uses' => 'frontend\TripsController@postDetail'));
// Route::post('trip/book', array('uses' => 'frontend\BooknowController@postBook'));

Route::get('places/{slug}', 'frontend\PageController@getPlace');

// Route::post('booknow', 'frontend\BooknowController@index');
// Route::post('trip', 'frontend\BooknowController@postBook');
// Route::get('trip/{slug}', array('as' => 'slug', 'uses' => 'frontend\TripsController@getDetail'));
// Route::post('trip/{slug}', array('uses' => 'frontend\TripsController@postDetail'));
Route::resource('trip', 'frontend\TripsController');


Route::get('page/{slug}', 'frontend\PageController@getPage');

Route::get('notfound', array('as' => 'notfound', 'uses' => 'frontend\HomeController@pageNotFound'));

//admin route open
// Route::group(array('prefix' => 'admin', 'middleware'=>'web'), function()
// {
Route::group(['prefix' => 'admin','middleware' => ['web']], function () {

Route::post('ajax/drag-drop-sorting', 'AjaxController@postDragDropSorting');

Route::resource('admins', 'AdminController');
Route::post('admins/delete', 'AdminController@destroy');
Route::get('admins/status/{id}', 'AdminController@status');
Route::post('admins/updatestatus/{id}', 'AdminController@postUpdateStatus');


Route::resource('users', 'UserController');
Route::post('users/delete', 'UserController@destroy');
Route::get('users/status/{id}', 'UserController@status');
Route::post('users/updatestatus/{id}', 'UserController@postUpdateStatus');

Route::resource('categories', 'CategoryController');
Route::post('categories/delete', 'CategoryController@destroy');
Route::get('categories/status/{id}', 'CategoryController@status');
Route::post('categories/updatestatus/{id}', 'CategoryController@postUpdateStatus');
Route::resource('dashboard', 'DashboardController');

Route::resource('banners', 'BannerController');
Route::post('banners/delete', 'BannerController@destroy');
Route::get('banners/status/{id}', 'BannerController@status');
Route::post('banners/updatestatus/{id}', 'BannerController@postUpdateStatus');

Route::resource('blogs', 'BlogController');
Route::post('blogs/delete', 'BlogController@destroy');
Route::get('blogs/status/{id}', 'BlogController@status');
Route::post('blogs/updatestatus/{id}', 'PostController@postUpdateStatus');

Route::resource('posts', 'PostController');
Route::post('posts/delete', 'PostController@destroy');
Route::get('posts/status/{id}', 'PostController@status');
Route::post('posts/updatestatus/{id}', 'BlogController@postUpdateStatus');

Route::resource('navs', 'NavController');
Route::post('navs/delete', 'NavController@destroy');
Route::get('navs/status/{id}', 'NavController@status');
Route::post('navs/updatestatus/{id}', 'NavController@postUpdateStatus');
Route::post('navs/change-type-create', 'NavController@postChangeTypeCreate'); 
Route::post('navs/change-type-update', 'NavController@postChangeTypeUpdate');

Route::resource('pages', 'PageController');
Route::post('pages/delete', 'PageController@destroy');
Route::get('pages/status/{id}', 'PageController@status');
Route::get('pages/parent/{id}', 'PageController@parent');
Route::post('pages/updatestatus/{id}', 'PageController@postUpdateStatus');


Route::resource('page-galleries', 'PageGalleryController');
Route::post('page-galleries/delete', 'PageGalleryController@destroy');
Route::get('pages/gallery/{id}', 'PageGalleryController@getPage');
Route::get('page-galleries/status/{id}', 'PageGalleryController@status');
Route::get('page-galleries/parent/{id}', 'PageGalleryController@parent');
Route::post('page-galleries/updatestatus/{id}', 'PageController@postUpdateStatus');

Route::resource('testimonials', 'TestimonialController');
Route::post('testimonials/delete', 'TestimonialController@destroy');
Route::get('testimonials/status/{id}', 'TestimonialController@status');
Route::post('testimonials/updatestatus/{id}', 'TestimonialController@postUpdateStatus');


    Route::resource('albums', 'AlbumController');
    Route::post('albums/delete', 'AlbumController@destroy');
    Route::get('albums/status/{id}', 'AlbumController@status');
    Route::post('albums/delete', 'AlbumController@destroy');
    Route::post('albums/updatestatus/{id}', 'AlbumController@postUpdateStatus');
    
    Route::resource('galleries', 'GalleryController');
    Route::post('galleries/delete', 'GalleryController@destroy');
    Route::get('albums/gallery/{id}', 'GalleryController@index');
    Route::get('galleries/status/{id}', 'GalleryController@status');
    Route::post('galleries/updatestatus/{id}', 'GalleryController@postUpdateStatus');

Route::resource('comments', 'CommentController');
Route::resource('packages', 'PackagesController');
Route::resource('places','PlacesController');
Route::resource('site-settings', 'SiteSettingController');
// Route::resource('control', 'LoginController');
});
//admin route closed



// frotend route open
Route::get('/','frontend\HomeController@index');

Route::get('aboutus', 'frontend\AboutusController@index');

Route::get('contactus', 'frontend\ContactusController@index');
Route::post('contactus', 'frontend\ContactusController@postContact');

Route::get('booknow', 'frontend\BooknowController@index');
Route::post('trip', 'frontend\BooknowController@postBook');

Route::get('gallery', 'frontend\GalleryController@index');
Route::get('common/{slug}', 'frontend\CommonController@index');
Route::get('gallery_detail', 'frontend\Gallery_detailController@index');
// Route::get('tour_detail', 'frontend\Tour_detailController@index');

Route::get('tour_list', 'frontend\Tour_listController@index');
Route::get('reviews/{slug}', 'frontend\ReviewController@index');
Route::post('review/store', 'frontend\ReviewController@store');
//Route::resource('reservation', 'frontend\ReservationController');

// Route::get('/home', 'frontend\BaseController');
  
Auth::routes();
Route::resource('control', 'LoginController');
 Route::get('admin/logout', 'LoginController@getLogout');


// Route::get('elfinder.ckeditor');