@extends('admin.layout')

@section('head')
    @parent
    <script type="text/javascript" src="../xtras/ckeditor/ckeditor.js"></script>
@stop 


@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {{ $title }}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
            <h2 class="bedcrumb">
                <a href="{!! url('admin/dashboard') !!}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                {!! $bredcrumb !!}     
                                
            </h2>
        
         @if( isset($model) )
   {!! Form::model($model, ['method' => 'PATCH','route' => ['testimonials.update', $model->id], 'files' => true ]) !!}

@else
    {!! Form::open(['route' => 'testimonials.store', 'files' => true ]) !!}
@endif
                <!-- left form -->
                <aside class="Form_box_left">
                <div class="insed_form">
                    <h1 class="form_head">Enter Details</h1>
                    <ul class="form_ul">
                        
                        <li>
                            <ul class="tw35">
                                <li>Name <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('name', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('name', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                        
                        <li>
                            <ul class="tw35">
                                <li>Email</li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('email', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('email', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                        
                          <li>
                            <ul class="tw35">
                                <li>Rating <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('rating', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('rating', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                        
                        
                        
                        
                        <li>
                            <ul class="tw35">
                                <li>Country <span class="req">*</span></li>
                            </ul>
                           <!--  App\Models\Country::pluck('name', 'id')), -->
                            <ul class="tw65">
                                <li>
                                    {!! Form::select('country_id', $countries->pluck('name', 'name'), null, array('class'=>'fsl')) !!}
                                    {!! $errors->first('country_id', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li> 
                                                
                        @if (isset($model) && $model->image)
                            <li>
                                <ul class="tw35">
                                    <li>Image</li>
                                </ul>
                                
                                <ul class="tw65">
                                    <li>
                                        <span class="checkkkk">{!! Form::checkbox('delete_image', '1') !!} Remove</span>
                                        <img src="{!!asset($model->thumb.$model->image)!!}" alt="{!! $model->title !!}" class="image_list" />
                                    </li>
                                </ul>
                            </li>
                        @endif
                        
                        
                        <li>
                            <ul class="tw35">
                                <li>Upload Image <br><span>size : 200px * 200px (jpg, png, gif)</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>
                                    {!! Form::file('image', array('class'=>'fip2')) !!}
                                    {!! $errors->first('image', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                          <li>
                            <ul class="tw35">
                                <li>Sent Date <span class="req">*</span><br><span>Eg. (0000-00-00)</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('sent_at', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('sent_at', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>  
                        <li>
                            <div class="editor_box">
                                {!! Form::textarea('review', null, array('class'=>'ckeditor')) !!}
                                {!! $errors->first('review', '<div class="err">:message</div>') !!}
                            </div>
                        </li>  
                        
                                                                 
                        
                    </ul>   
                </div>      
                </aside>
            
                <!-- right form -->
                <aside class="Form_box_right">
                <div class="insed_form">
              <h1 class="form_head">Select Trips</h1>
                    <div class="form_ulck">   

                        <?php
                       
                if(isset($model)){
                    $cds  = array();
                
                $cds = $post_testimonial_id;
}

                        else{ $cds=array('');
                    }
                       echo TreeHelper::trips($name='post_id[]', $cds, $table='posts', $terms=null, $order_by='id', $order='asc');

                     
                        ?>                                                                                                                                    
                    </div>
                    {{ $errors->first('post_id', '<div class="err">:message</div>') }} 



                    <ul class="form_ul2">                                                
                        <h1 class="form_head">Status</h1>
                        <li>                                
                            {!!
                                Form::select('status', array(
                                    '1' => 'Active', 
                                    '0' => 'Inactive'
                                    ),null,array('class'=>'fsl')
                                 )
                            !!}
                        </li>
                       
                        <li class="last_li_form">
                            {!! isset($model) ? Form::submit('Update', array('class'=>'fbt')) : Form::submit('Create', array('class'=>'fbt')) !!}
                            
                        </li>
                        
                    </ul>
                        
                </div>  
                </aside>
            {!! Form::close() !!}
        </div>
        
    </aside>
@stop    