@extends('admin.layout')


@section('head')
    @parent
    <link href="{{asset('public/admin/smartmenu/sm-blue.css')}}" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="{{asset('public/admin/smartmenu/jquery.smartmenus.js')}}"></script>
    <script type="text/javascript">
        $(function() {
            $('#main-menu').smartmenus({
                subMenusSubOffsetX: 1,
                subMenusSubOffsetY: -20
            });
        });
    </script>
@stop

@section('search')
    {!! Form::open(array('url' => 'admin/post/search', 'class' => 'search_box', 'name'=>'frmSearch')) !!}
    <span class="search_label">
            {!! Form::text('q', null, array('class'=>'fip', 'placeholder'=>'Search...')) !!}
        {!! Form::submit('', array('class'=>'search_bgg')) !!}
        </span>
    {!! Form::close() !!}
@stop
<meta name="csrf-token" content="{{ csrf_token() }}">
@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">

            <h2 class="bedcrumb">
                <a href="{!! url('admin/dashboard') !!}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                {!! $bredcrumb !!}   
            </h2>


            {!! Session::get('message') !!}

            <div class="button_right">
                <a href="{!! url('admin/posts/create') !!}" class="btn-green btn_hv">Create</a>
                <div class="btn-group">
                    <div class="btn btn-black" data-toggle="dropdown" data-hover="dropdown"><i class="fa fa-chevron-down"></i>&nbsp;&nbsp;Action</div>
                    <ul class="dropdown-menu">
                        <li><a href="javascript:void(0);" onclick="return actionSubmit('posts/updatestatus/1');">Activate</a></li>
                        <li><a href="javascript:void(0);" onclick="return actionSubmit('posts/updatestatus/0');">Deactivate</a></li>
                        <li><a href="javascript:void(0);" onclick="return actionConfirm('posts/delete','Delete');">Delete</a></li>
                    </ul>
                </div>
            </div>

            <div class="button_left">

                <div class="button_mult">
                    <ul id="main-menu" class="sm sm-blue">
                        <li><a href="javascript:void(0);">Category&nbsp;&nbsp;<i class="fa fa-chevron-down"></i></a>
                        {!! TreeHelper::menuAdmin('categories', 0, 'admin/posts') !!}
                        </li>
                    </ul>
                </div>

                <div class="btn-group">
                    <button class="btn btn-none" data-toggle="dropdown" data-hover="dropdown">Status&nbsp;&nbsp;<i class="fa fa-chevron-down"></i></button>
                    <ul class="dropdown-menu2">
                        <li><a href="{!! url('admin/posts') !!}">Any</a></li>
                        <li><a href="{!! url('admin/posts/status', array('status'=>1)) !!}">Active</a></li>
                        <li><a href="{!! url('admin/posts/status', array('status'=>0)) !!}">Inactive</a></li>
                        
                    </ul>
                     
                </div>

            </div>
            
{{ $models->links() }}
            <div class="table_holder">
                {!! Form::open(array('id' => 'frmListing')) !!}
                <table width="100%" border="0" cellspacing="1" cellpadding="0"  align="left" class="table" id="sortable" >
                    <tr class="row1 nodrop nodrag" >
                        <!-- <td class="hd_td">Code</td> -->
                        <td class="hd_td">Title</td>
                        <!-- <td class="hd_td">Gallery</td>
                        <td class="hd_td">Comments</td>
                        <td class="hd_td">Author</td> -->
                        <td class="hd_td">Categories</td>
                        <td class="hd_td">Move</td>
                        <td class="hd_td">Created</td>
                        <td class="hd_td">Updated</td>
                        <td class="hd_td">Status</td>
                        <td class="hd_td">{!! Form::checkbox('toggle_check', '', '', array('onclick'=>'toggleSelect();')); !!}</td>
                    </tr>

                    <?php $sort_orders = '';?>
                    <?php $i = 0;?>
                             @foreach ($models as $m)

                   

                        <?php $sort_orders.=$m->sort_order.',';?>
                        <tr class="{!! ($i%2==0) ? 'row2' : 'row1' !!}" id="{!! $m->id !!}">
                            <!-- <td>{!! $m->code !!}</td> -->
                            <td>{!! $m->title !!}<a href="{!! route('posts.edit', $m->id) !!}"><i class="fa fa-pencil fa_icon"></i></a></td>
                            <?php /*
                            <td><a href="{!! URL::to('admin/post-gallery/post', array('id'=>$m->id)) !!}"><i class="fa fa-picture-o fa_icon"> {!! $m->gallery->count() !!}</i></a></td>
                            <td><a href="{!! URL::to('admin/comment/post', array('id'=>$m->id)) !!}" ><i class="fa fa-comments fa_icon"> {!! $m->comments->count() !!}</i></a></td>
                            <td><a href="{!! URL::to('admin/user/update', array('id'=>$m->author->id)) !!}" > {!! ucfirst($m->author->first_name) !!}</i></a></td>
                            */ ?>
                           <td>
                        @foreach ($m->categories as $category)
                                    <a href= href="{{ route('categories.edit', $m->id) }}">{!! $category->title !!},</a>
                                @endforeach
                            </td>
                            <td class="move"><i class="fa fa-hand-o-up fa_icon"></i></td>
                            <td>{!! $m->created_at !!}</td>
                            <td>{!! $m->updated_at !!}</td>
                            <td>{!! $status[$m->status] !!}</td>
                            <td>{!! Form::checkbox('ids[]', $m->id) !!}</td>
                        </tr>
                        <?php $i++;?>
                    @endforeach


                </table>
                {!! Form::close() !!}
                @if(sizeof($models)==0)
                    {!! NO_RECORD !!}
                @endif
            </div>

 {{ $models->links() }}

 

        </div>
        <div class="marg10"></div>
    </aside>
@stop


@section('foot')
    @parent
    <script src="{{asset('public/admin/js/jquery.tablednd_0_5.js')}}" type="text/javascript"></script>
    <script type="text/javascript">
    
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
    
        $(document).ready(function(){
            $('#sortable').tableDnD({
                onDrop: function(table, row) {
                    //alert($.tableDnD.serialize());
                    $.post("ajax/drag-drop-sorting", {ids_order: $.tableDnD.serialize(), sort_orders:'<?php echo $sort_orders;?>', table:'posts' } );
                }
            });
        });
    </script>
@stop
