<?php

/*
|--------------------------------------------------------------------------
| Register The Laravel Class Loader
|--------------------------------------------------------------------------
|
| In addition to using Composer, you may use the Laravel class loader to
| load your controllers and models. This is useful for keeping all of
| your classes in the "global" namespace without Composer updating.
|
*/

ClassLoader::addDirectories(array(

	app_path().'/commands',
	app_path().'/controllers/admin',
	app_path().'/models',
	app_path().'/database/seeds',
    app_path().'/constants',
	app_path().'/custom',

));

/*
|--------------------------------------------------------------------------
| Application Error Logger
|--------------------------------------------------------------------------
|
| Here we will configure the error logger setup for the application which
| is built on top of the wonderful Monolog library. By default we will
| build a basic log file setup which creates a single file for logs.
|
*/

Log::useFiles(storage_path().'/logs/laravel.log');

/*
|--------------------------------------------------------------------------
| Application Error Handler
|--------------------------------------------------------------------------
|
| Here you may handle any errors that occur in your application, including
| logging them or displaying custom views for specific errors. You may
| even register several error handlers to handle different types of
| exceptions. If nothing is returned, the default error view is
| shown, which includes a detailed stack trace during debug.
|
*/

App::error(function(Exception $exception, $code)
{
	//Log::error($exception);
    echo "<pre>";print_r($exception);echo "</pre>";
});



/*
|--------------------------------------------------------------------------
| Maintenance Mode Handler
|--------------------------------------------------------------------------
|
| The "down" Artisan command gives you the ability to put an application
| into maintenance mode. Here, you will define what is displayed back
| to the user if maintenance mode is in effect for the application.
|
*/

App::down(function()
{
	return Response::make("Be right back!", 503);
});

/*
|--------------------------------------------------------------------------
| Require The Filters File
|--------------------------------------------------------------------------
|
| Next we will load the filters file for the application. This gives us
| a nice separate location to store our route and application filter
| definitions instead of putting them all in the main routes file.
|
*/

require app_path().'/filters.php';



//custome codes------------------------------------

//for define constants
require app_path().'/constants.php';

//for custom validations
Validator::resolver(function($translator, $data, $rules, $messages)
{
    return new CustomValidator($translator, $data, $rules, $messages);
});

App::missing(function($exception)
{
    $site_data = SiteSetting::find(1);

    define('SITE_TITLE',$site_data->title, TRUE);
    define('SITE_EMAIL',$site_data->email, TRUE);
    define('SITE_META_TITLE',$site_data->meta_title, TRUE);
    define('SITE_META_KEYWORDS',$site_data->meta_keywords, TRUE);
    define('SITE_META_DESCRIPTION',$site_data->meta_description, TRUE);

    $data['title'] = '404 : Page Not Found.';
    $data['meta_title'] = SITE_TITLE.' : 404 Page';
    $data['meta_keywords'] = '';
    $data['meta_description'] = '';
    $data['content'] = '<span style="text-align: center; font-size: 72px; display: block"><i class="fa fa-unlink"></i> 404 <i class="fa fa-unlink"></i></span>';

    $data['bredcrumb'] = BS.'404';

    View::share('site_data', $site_data);
    return Response::view('page.result', $data, 404);
});




