<?php

namespace App\Models;
use App\Models\Country;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Models\User;
use Illuminate\Support\Facades\Input;
use Str;
use Hash;
use Image;
use File;
class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table = 'users';
    protected $fillable = [
        'id', 'email', 'username', 'password', 'first_name', 'last_name', 'image', 'delete_image', 'country_id', 'created_at', 'updated_at', 'status'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
        'password_confirmation', 'remember_token',
    ];
    
   
    public $upload= 'public/uploads/users/';
    public $thumb=  'public/uploads/users/thumbs/';

    /**
     * Get the unique identifier for the user.
     *
     * @return mixed
     */
    public function getAuthIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Get the password for the user.
     *
     * @return string
     */
    public function getAuthPassword()
    {
        return $this->password;
    }

    /**
     * Get the e-mail address where password reminders are sent.
     *
     * @return string
     */
    public function getReminderEmail()
    {
        return $this->email;
    }
    
    
    
    
    
    
    //custom codes ----------------------------------------------------------------------------------------------
  public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }
    
    public function posts()
    {
        return $this->hasMany('App\Models\Post' , 'author_id');
    }
    
    public function comments()
    {
        return $this->hasMany('App\Models\Comment');
    }
    
    
    public static function createModel()
    {
         $model = new User(Input::all()) ;
    
         if($file = Input::hasFile('image')) {
            
            $file = Input::file('image') ;
                    
            $extension=Input::file('image')->getClientOriginalExtension();
            $image=Str::slug(Input::get('first_name')).time().'.'.$extension;
            Input::file('image')->move($model->upload, $image);
            if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
            {
                Image::make($model->upload.$image)->fit(200, 200)->save($model->thumb.$image);
            }
            $model->image = $image;
        }
        $model->admin = '1';
        $model->username=$model->username;
        $model->first_name=$model->first_name;
        $model->email = Str::lower(Input::get('email'));
        $model->password = Hash::make(Input::get('password'));
                    
        $model->save(); 
    }
    
    public static function updateModel($id)
    {       
        $inputs = Input::all();         
        $model = User::find($id);
        $model->fill($inputs);
        if (Input::hasFile('image'))
        {   
            if($model->image)
            
            {
                File::delete($model->upload.$model->image);
                File::delete($model->thumb.$model->image);
            }
            $extension=Input::file('image')->getClientOriginalExtension();
            $image=Str::slug(Input::get('title')).time().'.'.$extension;
            Input::file('image')->move($model->upload, $image);
            if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
            {
                Image::make($model->upload.$image)->resize(200, 200)->save($model->thumb.$image);
            }
            $model->image = $image;
        }
        else if(Input::get('delete_image'))
        {
            if($model->image)
            {
                File::delete($model->upload.$model->image);
                File::delete($model->thumb.$model->image);
            }
            $model->image = '';
        }
        $model->email = Str::lower(Input::get('email'));
        if(Input::has('password'))$model->password = Hash::make(Input::get('password'));
        $model->save(); 
    }
    
    public static function deleteModel()
    {       
        $models=User::whereIn('id', Input::get('ids'))->get(array('image'));
        foreach($models as $m)
        {
            File::delete(public_path().'/'.$m->upload.$m->image);
            File::delete(public_path().'/'.$m->thumb.$m->image);
            Comment::deleteModelByUser($m->id);
        }
        return User::whereIn('id', Input::get('ids'))->delete();                
    }
    
    public function getRememberToken()
    {
        return $this->remember_token;
    }

    public function setRememberToken($value)
    {
        $this->remember_token = $value;
    }

    public function getRememberTokenName()
    {
        return 'remember_token';
    }
    }