<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\PostGallery;
class PostGallery extends Model
{
   protected $table = 'post_galleries';	
	public $upload=	'uploads/post_gallery/';
	public $thumb=	'uploads/post_gallery/thumb/';	

	
	public function post()
    {
        return $this->belongsTo('Post', 'parent_id');
    }
	

	public static function createModel($title, $image)
	{		
		$model = new PostGallery();	
		$model->parent_id=Input::get('parent_id');
		$model->title=$title;
		$model->image=$image;	
		$model->status=Input::get('status');
		$model->sort_order = DbHelper::nextSortOrder($model->table);				
		$model->save();	
		
	}
	
	public static function updateModel()
	{		
			
		$model = PostGallery::find(Input::get('id'));
		
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete(public_path().'/'.$model->upload.$model->image);
				File::delete(public_path().'/'.$model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(200, 200)->save($model->thumb.$image);
			}
			$model->image = $image;
		}

		$model->title=Input::get('title');	
		$model->status=Input::get('status');		
		$model->save();					
	}
	
	public static function deleteModel()
	{				
		$models=PostGallery::whereIn('id', Input::get('ids'))->get(array('image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return PostGallery::whereIn('id', Input::get('ids'))->delete();						
	}
	
	public static function deleteModelByParent($id)
	{	
		$models=PostGallery::where('parent_id', $id)->get(array('id', 'image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return PostGallery::where('parent_id', $id)->delete();						
	}


	public static function deleteModelAll($array)
	{				
		$models=PostGallery::whereIn('id', $array)->get(array('image'));
		//echo "<pre>";print_r($models); echo "</pre>";die();
		foreach($models as $m)
		{
			//echo "<pre>";print_r($m); echo "</pre>";die();
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		PostGallery::whereIn('id', $array)->delete();
		//return PostGallery::whereIn('id', Input::get('ids'))->delete();						
	}
	

	
}