<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Cache;
use App\Models\User;
use App\Models\Country;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Redirect;
use Session;
use Illuminate\Support\Facades\Auth;
class UserController extends Controller
{
    private $controller='admin/users';
    private $rpp=5; //row per page //default-RPP
    private $title='Users';
     private $table='users';
    private $sort_by='first_name';
    private $sort_order='asc';
    private $listing_page='admin.page.users';
    private $create_form='admin.page.user_ae';
    private $update_form='admin.page.user_ae';
    private $change_password_form='admin.page.change_password';
    
    private $status = array(
        '0'=>'<span class="deem">Unverified</span>', 
        '1'=>'<span class="green">Active</span>',
        '2'=>'<span class="red">Suspended</span>'                                       
    );
     public function __construct(){
$this->middleware('cadmin');
} 


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $data['title'] = $this->title;           
      $data['status'] = $this->status;                 
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;
        
        $data['models'] = User::where('admin','!=',0)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
       
    return View($this->listing_page, $data);
    
    

}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
  public function status($status) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];
        
        $data['models'] = User::where('admin','!=',1)
            ->where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }


    public function create()
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
        
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';        
      $data['countries'] = Country::all();
       // dd($data['countries']);     
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = array(
            "email" => "required|email|unique:".$this->table,
            "password" => "required|confirmed|min:6|max:18",
            "first_name" => "required",
            "image" => "mimes:jpeg,gif,png",
            "country_id" => "required",                 
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        User::createModel();
  
        return Redirect($this->controller)->with('message','<div class="success">1 '.CREATED.'</div>');
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = $this->title;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';
        
            $data['countries'] = Country::all();
        
         $data['model'] = User::find($id);
        
        return View($this->create_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        $rules = array(
            "password" => "confirmed|min:6|max:18",
            "country_id" => "required",                 
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        
        User::updateModel($id);
        return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function postUpdateStatus($status) 
    {       
        
        $affected_models = User::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }

    public function destroy()
    {
         $affected_models = User::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.$affected_models.' '.DELETED.'</div>'); 
    }
}
