<?php

namespace App\Http\Controllers;
use Session;
use Illuminate\Http\Request;
use Cache;
use Redirect;
use App\Models\SiteSetting;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
class SiteSettingController extends Controller
{
    private $controller='admin/site-settings';
    private $title='Site Setting';
    private $table='site_settings';

    private $update_form='admin.page.site_settings';
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct(){
$this->middleware('cadmin');
} 
    public function index()
    {
       $data['title'] = $this->title;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.'Site Setting';
      
        $data['model'] = SiteSetting::find(1);
        return View($this->update_form, $data);
    
}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = array(
            "title" => "required",
            "email" => "required",
            "email_2"=> "required|email",
            "phone" =>  "required",
            "phone2"    =>  "required",
            "meta_keywords" => "required",
            "meta_description" => "required",
                        
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        SiteSetting::updateModel();
        return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
