<?php

namespace App\Http\Controllers;
use App\Models\Post;
use Cache;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Redirect;
use Session;
use TreeHelper;
use BredcrumpHelper;
use App\Models\Image;
use App\Models\Category;
use Comment;

class PostController extends Controller
{

    private $controller='admin/posts';
    //row per page //default-RPP
    private $rpp =30;
    private $title='trips';
    private $table='posts';
    private $sort_by='sort_order';
    private $sort_order='asc';
    
    private $listing_page='admin.page.posts';
    private $create_form='admin.page.post_ae';
    private $update_form='admin.page.post_ae';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                                        
    );
    public function __construct(){
$this->middleware('cadmin');
} 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       
        $data['title'] = ucfirst($this->title);
       $data['status'] = $this->status;     
                
        //bredcrumb
        $data['bredcrumb'] = ABS.ucfirst($this->title);

       
        $data['models'] = Post::with('categories')
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    
}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function category($id) 
    {
        $data['title'] = ucfirst($this->title);
        $data['status'] = $this->status;                
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, ucfirst($this->title));     
        $data['bredcrumb'].= BredcrumpHelper::admin('categories', $id, $this->controller.'/category');
        
        
        //post without child categories
        /*$data['models'] = Category::find($id)->posts()
        
            ->with('categories','author','comments','gallery')
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);*/
        
        
        //posts with childs categories
        $ids=TreeHelper::id('categories', $id, $terms=NULL, $order_by='sort_order', $order='asc');
        $data['models'] = Post::whereHas('categories', function($query) use ($ids) { 
                $query->whereIn('id', $ids); 
            })
            ->with('categories','author','comments','gallery')
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);     
            
        
        return View($this->listing_page, $data);
    }
    public function create()
    {

        $data['title'] = $this->title;
        $data['status'] = $this->status;        
                
        $data['bredcrumb'] = ABS.link_to($this->controller, ucfirst($this->title));
        $data['bredcrumb'].= ABS.'Create';
        
        //bredcrumb
            
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store()
    {
        // dd(Input::all());
        $rules = array(
            //"code" => "required|unique:".$this->table,
            "categories" => "required",
            "title" => "required|unique:".$this->table
        );

//echo "<pre>";print_r(Input::hasFile('image'));echo "</pre>"; die();
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }

        
        Post::createModel();
        return Redirect($this->controller)->with('message','<div class="success">1 '.CREATED.'</div>');
        
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function status($status) 
    {
        $data['title'] = ucfirst($this->title);
        $data['status'] = $this->status;        
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, ucfirst($this->title));
        $data['bredcrumb'].= ABS.$this->status[$status];

        $data['models'] = Post::with('categories','author','comments','gallery')
            ->where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }
    public function show($id)
    {
       $data['title'] = ucfirst($this->title);
        $data['status'] = $this->status;                
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, ucfirst($this->title));     
        $data['bredcrumb'].= BredcrumpHelper::admin('categories', $id, $this->controller.'/category');  
        //post without child categories
        /*$data['models'] = Category::find($id)->posts()
        
            ->with('categories','author','comments','gallery')
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);*/
        //posts with childs categories
        $ids=TreeHelper::id('categories', $id, $terms=NULL, $order_by='sort_order', $order='asc');
        $data['models'] = Post::whereHas('categories', function($query) use ($ids) { 
                $query->whereIn('id', $ids); 
            })
            ->with('categories','author','comments','gallery')
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);     
            
        
        return View($this->listing_page, $data);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
        
      $data['title'] = ucfirst($this->title);
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, ucfirst($this->title));
        $data['bredcrumb'].= ABS.'Update';
        
      $data['model'] = Post::find($id);
       $data['category_id'] = Category::all();
        
        $data['gallery'] = Post::find($id)->where('status','1')->get();
          
       $data['post_category_id'] = Post::find($id)->categories()->pluck('category_id')->toArray();;

// dd($data);
        
        return View($this->create_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        $rules = array(
            //"code" => "required|unique:".$this->table.",code,".Input::get('id'),
            "categories" => "required",
            "title" => "required"
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Post::updateModel($id);
        return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function postUpdateStatus($status) 
    {       
        $affected_models = Post::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }
    public function destroy()
    {
       $affected_models = Post::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.$affected_models.' '.DELETED.'</div>'); 
    }
}
