<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use Cache;
use App\Models\Nav;
use Redirect;
use BredcrumpHelper;
use App\Models\Page;
use App\Models\category;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;

class NavController extends Controller
{
    private $controller='admin/navs';
    private $rpp=RPP;//row per page //default-RPP
    private $title='Menu';
    private $table='navs';
    private $sort_by='sort_order';
    private $sort_order='asc';
    
    private $remember_page='nav_parent_id';
    
    private $listing_page='admin.page.navs';
    private $create_form='admin.page.nav_a';
    private $update_form='admin.page.nav_e';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                            
    );              
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
       public function status($status) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;
        
        Cache::forget($this->remember_page);            
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];
        
        $data['models'] = Nav::with('childs')
            ->where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }
    public function index()
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;
        
       Cache::forget($this->remember_page);
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;      
         
        $data['models'] = Nav::with('childs')
            ->where('parent_id', 0)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    
}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
       $data['title'] = $this->title;
        $data['parent_id']=Cache::get($this->remember_page)?Cache::get($this->remember_page):null;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';
            
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = array(
            "type" => "required",
            "type_id" => "required_if:type,pages|required_if:type,categories|required_if:type,pcats|required_if:type,posts",
            "title" => "required_if:type,none|required_if:type,routes|required_if:type,other",  
            "url" => "required_if:type,routes|required_if:type,other",
                    
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Nav::createModel();
        
        if (Cache::get($this->remember_page))return Redirect($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">'.CREATED.'</div>');    
        else return Redirect($this->controller)->with('message','<div class="success">'.CREATED.'</div>');
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function show($id)
    {
       
        $data['title'] = $this->title;
        $data['status'] = $this->status;
        
        //for return page
        Cache::forever($this->remember_page, $id);              
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);      
        $data['bredcrumb'].= BredcrumpHelper::admin($this->table, $id, $this->controller.'/category');
        
        $data['models'] = Nav::with('childs')
            ->where('parent_id', $id)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);

      
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       $data['title'] = $this->title;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';
        
        $data['model'] = Nav::find($id);        
        return View($this->update_form, $data);
    }
    

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        // dd(Input::all());
        Nav::updateModel($id);
    
        if (Cache::get($this->remember_page))return Redirect($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">1 '.UPDATED.'</div>');  
        return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function postChangeTypeCreate() 
    {       
        $data['type']=Input::get('type');       
        return View('admin.page.nav_type_partial_a', $data);
    }
    
    public function postChangeTypeUpdate() 
    {       
        $data['type']=Input::get('type');       
        return View('admin.page.nav_type_partial_e', $data);
    }
    
   public function postUpdateStatus($status) 
    {       
        $affected_models = Nav::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }



    public function destroy()
    {
           
        $affected_models = Nav::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.DELETED.'</div>');  
    }
}
