<?php

namespace App\Http\Controllers;
use Breadcrumbs;
use Illuminate\Http\Request;
use Session;
use App\Models\User;
class DashboardController extends Controller
{
    private $controller='admin/dashboard';
    private $rpp=500;//row per page //default-RPP
    private $title='Categories';
    private $table='categories';
    private $sort_by='sort_order';
    private $sort_order='asc';
    
    private $remember_page='category_parent_id';
    private $listing_page='admin.page.categories';
    private $create_form='admin.page.category_ae';
    private $update_form='admin.page.category_ae';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                            
    );

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
     
      if(Session::has('sessUser')){
        $data['title'] = 'Dashboard';
        $data['user'] = User::where('username','=',Session('sessUser'))->get();
        return view('admin.dashboard', $data);
    }else{
        Session::flash('message','Login to proceed..');
        return redirect('control');
    }
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
