<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Cache;
use App\Custom\DbHelper;
use Illuminate\Support\Str;
use App\Models\Album;
use APP\Models\Gallery;
use Illuminate\Support\Facades\Input;
use BredcrumpHelper;
use Redirect;
class AlbumController extends Controller
{
     private $controller='admin/albums';
    private $rpp=RPP;//row per page //default-RPP
    private $title='Albums';
    private $table='albums';
    private $sort_by='sort_order';
    private $sort_order='asc';
    private $ctitle='Albums Create';
    private $listing_page='admin.page.albums';
    private $create_form='admin.page.album_ae';
    private $update_form='admin.page.album_ae';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                                        
    );  

    public function __construct(){
$this->middleware('cadmin');
}     
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $data['title'] = $this->title;
        $data['status'] = $this->status;        
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;
        
        $data['models'] = Album::with('gallery')
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);     
        return View($this->listing_page, $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function status($status) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];

        $data['models'] = Album::with('gallery')
            ->where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }   


    public function create()
    {
         $data['title'] = $this->ctitle;
        $data['status'] = $this->status;        
                
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';
            
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         $rules = array(
            "title" => "required|unique:".$this->table,
            "image" => "required",       
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Album::createModel();
        return Redirect($this->controller);
        
    }
    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    
    public function show($id)
    {
       }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = $this->title;
       $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';
        
        
        $data['model'] = Album::find($id);
        return View($this->create_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
     $rules = array(
            "title" => "required"
                      
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Album::updateModel($id);
    
        return Redirect($this->controller)->with('message');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function postUpdateStatus($status) 
    {       
        $affected_models = Album::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }
    public function destroy()
    {
        // dd(Input::all());
         $affected_models = Album::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.$affected_models.' '.DELETED.'</div>'); 
    }
    
}
