@extends('layouts.layout')
@section('content')
 
 
     <main>
      <div class="content-block">

        <div class="top-breadcrumb">
          <div class="container">
            <ul class="breadcrumb">
            <li><a href="{{ url('/') }}"> Home</a></li>
                  {!! $bredcrumb !!}   
            </ul>
          </div>
        </div>

        <div class="main-content">
          <div class="container">
            <div class="row">
              <div class="col-xs-12 col-sm-8 col-md-9 left-block">
                <h2 class="tour-title">{{ $model->title }}</h2>
                
 @if(Session::has('message'))
                        <div class = "alert alert-success">
                            {!! Session::get('message') !!}
                        </div>

                    @endif
                    
                <figure>
                  <img src="{{ url('public/uploads/featured', $model->featuredimage) }}" alt="title">                    
                </figure><!--package-->



                <div class="highlight-info">   
                            
                     <a href="#">{!! substr($model->useful_information,0,1000) !!}</a>
                           
                    <div class="clearfix"></div>
                </div>
                
              
                
<!--                <div class="tabbable-panel">
                    <div class="tabbable-line">
                        <ul class="nav nav-tabs ">
                            <li class="active">
                                <a href="#tab_1" data-toggle="tab">Tab 1 </a>
                            </li>
                            <li>
                                <a href="#tab_2" data-toggle="tab">Tab 2 </a>
                            </li>
                            <li>
                                <a href="#tab_3" data-toggle="tab">Tab 3 </a>
                            </li>

                        </ul>

                        <div class="tab-content">
                            <div class="tab-pane active" id="tab_1">
                            </div>

                            <div class="tab-pane" id="tab_2">
                            </div>
                        </div>
                    </div>
                </div>-->
                <div class="tabbable-panel">
                    <div class="tabbingx tabbing-line">
                        <ul class="tabNavx nav nav-tabs">
                            <li @if(!Input::all()) class="active" @endif><a href="#tab1" data-toggle="tab">trip overview</a></li>
                            <li><a href="#tab2" data-toggle="tab">itinerary</a></li>
                            <li><a href="#tab3" data-toggle="tab">dates & price</a></li>
                            <li><a href="#tab4" data-toggle="tab">reviews</a></li>
                            <li><a href="#tab5" data-toggle="tab">what's included</a></li>
                            <li @if(Input::all()) class="active" @endif><a href="#tab6" data-toggle="tab">enquire or book</a></li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane @if(!Input::all()) active @endif" id="tab1">
                                <h3>Trip Introduction</h3>
                                {!! substr($model->content,0,80000) !!}
                            </div>


                            <div class="tab-pane" id="tab2">
                                <div class="box-overview">
                                    {!! substr($model->itinerary,0,80000) !!}
                                </div><!--box-overview-->
                            </div>


                          
                            <div class="tab-pane" id="tab3">
                                <h3>Dates & Prices</h3>
                                <p>{!! substr($model->departures,0,4000) !!}</p>
                                  @if($model->departures_costs && $model->departures_costs!='N;')
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Trip Start Date</th>
                                                <th>Trip End Date</th>
                                                <th>Trip Price</th>                     
                                                <th>Status</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach(array_chunk(unserialize($model->departures_costs),4) as $a)
                                            {{ Form::open() }}
                                            <?php
                                            $starts = $a[0]['starts'];
                                            $ends = $a[1]['ends'];
                                            $costs = $a[2]['costs'];
                                            $status = $a[3]['status'];
                                            
                                            $time = strtotime($starts);
                                            $times = strtotime($ends);
                                            $current_time = strtotime("now");
                                            ?>
                                            {{ csrf_field() }}
                                            {{ Form::hidden('start', $starts) }}
                                            {{ Form::hidden('end', $ends) }}
                                            {{ Form::hidden('cost', $costs) }}
                                            {{ Form::hidden('status', $status) }}
                                            @if($time >= $current_time)
                                            <tr>
                                                <td>{{ date('j F Y',$time) }}</td>
                                                <td>{{ date('j F Y',$times) }}</td>
                                                <td>{{ $costs }}</td>
                                                <td><div class="spaces" data-toggle="tooltip" data-placement="top" title="Bookng Open for solo group">{{ $status }}</div></td>
                                                
                                                <td><button type="submit" class="book-now">book now</button></td>
                                            </tr>
                                            @endif
                                            
                                            {{ Form::close() }}
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                @endif
                            </div>
                            


                            @if(sizeof($model->post_testimonial)>0)

                            <div class="tab-pane" id="tab4">
                                <div class="reviews-box">

                                    @foreach($model->post_testimonial as $tm)
                                    <div class="review-info">
                                        <h2>{{ $model->title }}</h2>
                                        <ul>
                         <li><i class="fa fa-star"></i></li> 
                  	<li><i class="fa fa-star"></i></li> 
                  	<li><i class="fa fa-star"></i></li> 
                  	<li><i class="fa fa-star"></i></li> 
                  	<li><i class="fa fa-star"></i></li>
                                        </ul>
                                        <p class="name">{{ $tm->name }}</p>
                                       <p class="name"> {{ $tm->country_id }}</p>
                                        <span><i class="fa fa-calendar"></i>{{ $tm->sent_at }}</span>

                                        {!! substr($tm->review,0,6000) !!}
                                    </div>
                                    @endforeach                       
                                    <a href="#" id="loadMore">Load More</a>
                                </div>
                            </div>
                            @endif
                            <div class="tab-pane" id="tab5">
                                <div class="box-overview cost-include">
                                    <h3>What is Included in the Cost</h3>
                                    <ul>
                                        {!! substr($model->cost_includes,0,4000) !!}
                                    </ul>
                                </div><!--box-overview-->

                                <div class="box-overview cost-exclude">
                                    <h3>What is Excluded in the Cost</h3>
                                    <ul>
                                        {!! substr($model->cost_excludes,0,4000) !!} 
                                    </ul>
                                </div><!--box-overview-->
                            </div>

                            <div class="tab-pane @if(Input::all()) active @endif" id="tab6">
                                <div class="booking-form">

                                    {!! Session::get('message') !!}
                                
                                 
          {{ Form::open(['url' => 'trip']) }}
              <input type="hidden" value="{{ csrf_token() }}" name="_token">
                                    
                                    <div class="form-line personal-info">
                                        <h3>personal information</h3>

                                        <div class="form-group form-box">
                                            <label>Title :</label>
                                            <ul>
                                                <li> {{Form::checkbox('gender', 'male')}}Mr.</li>
                                                <li> {{Form::checkbox('gender', 'female')}}Ms. </li>
                                                <li> {{Form::checkbox('gender', 'male')}}Dr.</li>
                                            </ul>
                                        </div><!--form-box-->

                                        <div class="form-group form-box">
                                            <div class="row">
                                                <div class="col-xs-12 col-sm-4 col-md-4 form-detail">
                                                    <label>First Name <span class="astrick">*</span></label>
                                                    {{ Form::text('first_name', null, ['class' => 'form-control', 'placeholder'=>'First Name','required'=>'required']) }}
                                                    {!! $errors->first('first_name', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->

                                                <div class="col-xs-12 col-sm-4 col-md-4 form-detail">
                                                    <label>Middle Name</label>
                                                    {{ Form::text('middle_name', null, ['class' => 'form-control', 'placeholder'=>'Middle Name']) }}
                                                    {!! $errors->first('middle_name', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->

                                                <div class="col-xs-12 col-sm-4 col-md-4 form-detail">
                                                    <label>Last Name <span class="astrick">*</span></label>
                                                    {{ Form::text('last_name', null, ['class' => 'form-control', 'placeholder'=>'Last Name','required'=>'required']) }}
                                                    {!! $errors->first('last_name', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->
                                            </div>
                                        </div><!--form-box-->

                                        <div class="form-group form-box">
                                            <div class="row">
                                                <div class="col-xs-12 col-sm-6 col-md-6 form-detail">
                                                    <label>Your Email <span class="astrick">*</span></label>
                                                    {{ Form::text('email', null, ['class' => 'form-control', 'placeholder'=>'Your Email','required'=>'required']) }}
                                                    {!! $errors->first('email', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->

                                                <div class="col-xs-12 col-sm-6 col-md-6 form-detail">
                                                    <label>Mobile Number <span class="astrick">*</span></label>
                                                    {{ Form::text('number', null, ['class' => 'form-control', 'placeholder'=>'98xxxxxx','required'=>'required']) }}
                                                    {!! $errors->first('number', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->

                                            </div>
                                        </div><!--form-box-->

                                        <div class="form-group form-box">
                                            <div class="row">
                                                <div class="col-xs-12 col-sm-6 col-md-6 form-detail">
                                                    <label>Address</label>
                                                    {{ Form::text('address', null, ['class' => 'form-control', 'placeholder'=>'Enter Your Address','required'=>'required']) }}
                                                    {!! $errors->first('address', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->

                                                <div class="col-xs-12 col-sm-6 col-md-6 form-detail">
                                                    <label>Country <span class="astrick">*</span></label>
                                                    {!! Form::select('country_id', $countries->pluck('name', 'name'), null, array('class'=>'form-control','required'=>'required')) !!}
                                                    {!! $errors->first('address', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->
                                            </div>
                                        </div><!--form-box-->
                                    </div>

                                    <div class="form-line trips-info">
                                        <h3>trips information</h3>

                                        <div class="form-group form-box">
                                            <label>Trip Name <span class="astrick">*</span></label>
                                            {{ Form::text('triptitle',  $model->title, ['class' => 'form-control','placeholder'=>'Trip Title','readonly','required'=>'required']) }}
                                            {!! $errors->first('triptitle', '<div class="err">:message</div>') !!}
                                        </div><!--form-box-->

                                        <div class="form-group form-box">
                                            <div class="row">
                                                <div class="col-xs-12 col-sm-6 col-md-6 form-detail">
                                                    <label>Arrival Date <span class="astrick">*</span></label>
                                                    {{ Form::text('arrivaldate', \Illuminate\Support\Facades\Input::get('start'), ['class'=>'form-control','required'=>'required']) }}
                                                    {{ $errors->first('arrivaldate', '<div class="err">:message</div>') }}
                                                </div><!--form-detail-->

                                                <div class="col-xs-12 col-sm-6 col-md-6 form-detail">
                                                    <label>Departure Date <span class="astrick">*</span></label>
                                                    {{ Form::text('departures', \Illuminate\Support\Facades\Input::get('end'), ['class'=>'form-control','required'=>'required']) }}
                                                    {{ $errors->first('departures', '<div class="err">:message</div>') }}
                                                </div><!--form-detail-->

                                            </div>
                                        </div><!--form-box-->

                                        <div class="form-group form-box">
                                            <div class="row">
                                                <div class="col-xs-12 col-sm-4 col-md-4 form-detail">
                                                    <label>No of Days <span class="astrick">*</span></label>
                                                    {{ Form::text('days', null, ['class' => 'form-control', 'placeholder'=>'No of Days','required'=>'required']) }}
                                                    {!! $errors->first('days', '<div class="err">:message</div>') !!}

                                                </div><!--form-detail-->

                                                <div class="col-xs-12 col-sm-4 col-md-4 form-detail">
                                                    <label>Hotel Category <span class="astrick">*</span></label>
                                                    {!!  Form::select('hotelcategories', array(
                                                    '' => '- - - Select - - -',
                                                    '5star' => '5 Star',
                                                    '4star' => '4 Star',
                                                    '3star' => '3 Star',
                                                    '2star' => '2 Star',
                                                    'heritage' => 'Heritage',
                                                    'standard' =>'Standard',
                                                    'budget' =>'Budget' ),null, ['class'=>'form-control'])  !!}
                                                    {!! $errors->first('hotelcategories', '<div class="err">:message</div>') !!}
                                                </div><!--form-detail-->

                                                <!-- <div class="col-xs-12 col-sm-4 col-md-4 form-detail">
                                              <label>Payment Mode <span class="astrick">*</span></label><form>
                                             <select class="form-control">
                                             <option>Select One</option>
                                             <option>Wild Transfer</option>
                                             <option>Credit Card</option>
                                          </select>
                                                    </div><!--form-detail-->

                                            </div>
                                        </div><!--form-box-->   

                                        <div class="form-group form-box">
                                            <div class="row">
                                                <div class="col-xs-12 col-sm-12 col-md-12 form-detail">
                                                    <label>No of Person <span class="astrick">*</span></label>
                                                    <div class="numb-col">


                                                        {{ Form::select('adultperson', [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], null,['class'=>'form-control','placeholder'=>'Adults','required'=>'required']) }}
                                                        {{ $errors->first('adultperson', '<div class="err">:message</div>') }}
                                                        
                                                        
                                                        {{ Form::select('childperson', [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15], null,['class'=>'form-control','placeholder'=>'Childs']) }}
                                                        {{ $errors->first('childperson', '<div class="err">:message</div>') }}

                                                    </div>
                                                </div><!--form-detail-->
                                            </div>
                                        </div><!--form-box-->


                                        <div class="form-group form-box">
                                            <label>Also interested in: </label>
                                            <ul>
                                                <li>  {{ Form::checkbox('interestedin', 'everestflight') }}Mt. Everest Flight</li>
                                                <li>  {{ Form::checkbox('interestedin', 'airticket') }}Air Ticket </li>
                                                <li>  {{ Form::checkbox('interestedin', 'airportpickup') }}Airport Pickup</li>
                                            </ul>
                                        </div><!--form-box-->

                                        <div class="form-group form-box">
                                            <label>Your plan in details :</label>
                                            {{ Form::textarea('enquiry', null, [ 'row'=>'10','class' => 'form-control', 'placeholder'=>'Write Your Message']) }}
                                            {{ $errors->first('enquiry', '<div class="err">:message</div>') }}
                                        </div><!--form-box-->
                                    </div>                 

                                    <div class="input-btn">
                                        <input type="submit" value="submit" >
                                    </div>


                                    {{ Form::close() }}
                                </div><!--booking-form-->
                            </div>

                        </div><!--tabcontainer-->
                    </div><!--tabbing-->
                </div>
              </div><!--content-left-->

              <div class="col-xs-12 col-sm-4 col-md-3 right-block">
                <div class="right-content-title">
                  <div class="share-col">
                    <ul>
                      <li>share:</li>
                      <li>
                        <a href="#"><i class="fa fa-facebook"></i></a>
                      </li>
                      <li>
                        <a href="#"><i class="fa fa-twitter"></i></a>
                      </li>
                      <li>
                        <a href="#"><i class="fa fa-linkedin"></i></a>
                      </li>
                      <li>
                        <a href="#"><i class="fa fa-google-plus"></i></a>
                      </li>
                      <li>
                        <a href="#"><i class="fa fa-pinterest"></i></a>
                      </li>
                      <li>
                        <a href="#"><i class="fa fa-pinterest"></i></a>
                      </li>
                    </ul>
                  </div>
                </div>

                <div class="right-content-title">
                <div class="trip-fact">
                 <h3>Trip Facts</h3>
                 <ul>
                 <li><strong>Trip Code:</strong> {{ $model->tripcode }}</li>
                 <li><strong>Trip duration:</strong> {{ $model->duration }}</li>
                 <li><strong>Grade:</strong> {{ $model->grade }}</li>
                 <li><strong>Group size:</strong> {{ $model->groupsize }}</li>
                 <li><strong>Max-Altitude:</strong> {{ $model->altitude }}</li>
                 <li><strong>Activity:</strong> {{ $model->activity }}</li>
                 <li><strong>Starts in:</strong> {{ $model->starts }}</li>
                 <li><strong>Ends in:</strong> {{ $model->ends }}</li>
                 <li><strong>Accomodation:</strong> {{ $model->accomodation }}</li>
                 <li><strong>Transportation:</strong> {{ $model->transportation }}</li>
                 <li><strong>Best Time:</strong> {{ $model->besttime }}</li>
                      </ul>
                  </div>
                </div><!--right-content-title-->

                <div class="right-content-title">
                  <div class="trip-reviews">
                    <a class="btn btn-info" data-toggle="collapse" data-target="#reviews-post">Post a Review</a>
                      <div id="reviews-post" class="collapse">
                      
                       {{ Form::open(['url' => 'review/store']) }}
                         <div class="form-group">
                       
                      {{ Form::text('name', null, ['class' => 'form-control', 'placeholder'=>'Full Name','required'=>'required']) }}
                        {!! $errors->first('name', '<div class="err">:message</div>') !!}
                         </div>


                         <div class="form-group">
                            {{ Form::text('email', null, ['class' => 'form-control','placeholder'=>'Your Email']) }}
                         {!! $errors->first('email', '<div class="err">:message</div>') !!}
                         </div>

                        <div class="left-inner-addon form-group">
                         {!! Form::select('country_id', $countries->pluck('name', 'name'), null, array('class'=>'form-control','required'=>'required')) !!}
                  {!! $errors->first('country_id', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                         <div class="form-group">
                           
                           {{ Form::text('triptitle', null, ['class' => 'form-control', 'placeholder'=>'Title','required'=>'required']) }}
                        {!! $errors->first('triptitle', '<div class="err">:message</div>') !!}
                         </div>

                         <div class="form-group">
                             {{ Form::text('rating', null, ['class' => 'form-control', 'placeholder'=>'Give A Rating(*****)','required'=>'required']) }}
                        {!! $errors->first('rating', '<div class="err">:message</div>') !!}
                            <p>Please rate the package.</p>
                           {{ Form::textarea('review', null, ['class' => 'form-control','placeholder'=>'Type Your Review']) }}
                         {!! $errors->first('review', '<div class="err">:message</div>') !!}
                         </div>

                         <div class="review-btn">
                          <button type="submit">Post My Review</button>
                         </div>

                      {{ Form::close() }}
                      </div>
                  </div>
                </div><!--right-content-title-->

                   <div class="right-content-title">
                  <div class="quick-contact">
           
                    <h3>For Quick Enquiry</h3>
               {{ Form::open(['url' => 'contactus']) }}
              <input type="hidden" value="{{ csrf_token() }}" name="_token">

                <div class="left-inner-addon form-group">
                 {{ Form::text('name', null, ['class' => 'form-control', 'placeholder'=>'Full Name','required'=>'required']) }}
                        {!! $errors->first('name', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                          {{ Form::text('contact_num', null, ['class' => 'form-control', 'placeholder'=>'Contact No','required'=>'required']) }}
                        {!! $errors->first('contact_num', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                         {{ Form::text('email', null, ['class' => 'form-control', 'placeholder'=>'Your Email','required'=>'required']) }}
                {!! $errors->first('email', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                         {!! Form::select('country_id', $countries->pluck('name', 'name'), null, array('class'=>'form-control','required'=>'required')) !!}
          {!! $errors->first('country_id', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                           {{ Form::textarea('enquiry', null, ['class' => 'form-control', 'placeholder'=>'Type Your Enquiry Here','required'=>'required']) }}
                        {!! $errors->first('enquiry', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="captche form-group">
                          <span>9+1= </span> <input type="text" class="form-control" placeholder="Enter above code" />
                        </div>

                        <div class="input-btn">
                          <input class="btn" type="submit" value="submit">
                        </div>
                    </form>
                  </div>
                </div><!--right-content-title-->

              </div><!--content-left-->
            </div>
          </div>
        </div>

      </div><!--content-block-->

    </main>

    @stop