@extends('layouts.layout')
@section('content')
    <main>
      <div class="content-block">

        <div class="top-breadcrumb">
          <div class="container">
            <ul class="breadcrumb">
              <li><a href="/">home</a></li>
              <li>Contact Us</li>
            </ul>
          </div>
        </div>
        
                    
        <div class="main-content">
          <div class="container">
            <div class="row">
              <div class="col-xs-12 col-sm-8 col-md-9 left-block">
                <div class="contact-block">
                  <h4>Friendship Nepal Tours and Travels (P) Ltd.</h4>
                  <ul>
                    <li><label>Address :</label>{{$site_setting->address}}</li>
                    <li><label>Cell No :</label>{{$site_setting->phone}} (Whatsapp/Viber or Direct call)</li>
                    <li><label>Tel :</label>{{$site_setting->phone2}}</li>
                    <li><label>Fax :</label>{{$site_setting->fax}}</li>
                    <li><label>Skype :</label> <a href="{{$site_setting->skype}}">kbroka</a></li>
                    <li><label>Email :</label><a href="mailto:{{$site_setting->email}}"> sales@friendshiptravels.com</a> or <a href="mailto:tournepal@gmail.com">tournepal@gmail.com</a></li>
                  </ul>
                </div><!--contact-block-->
                <div class="friendship-map">
                  <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3532.155103733365!2d85.30993131546909!3d27.712496982789748!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39eb18fdbedff3d1%3A0x68bcb1fbedc6d72!2sFriendship+Nepal+Tours+%26+Travels!5e0!3m2!1sen!2snp!4v1484817547039"  frameborder="0" style="border:0" allowfullscreen></iframe>
                </div>
              </div><!--content-left-->



            <div class="col-xs-12 col-sm-4 col-md-3 right-block">
            	 @if(Session::has('message'))
                        <div class = "alert alert-success">
                            {!! Session::get('message') !!}
                        </div>

                    @endif

                <div class="right-content-title">
                  <div class="quick-contact">
                    <h3>For Quick Enquiry</h3>
              {{ Form::open(['url' => 'contactus']) }}
              <input type="hidden" value="{{ csrf_token() }}" name="_token">
               
              <div class="left-inner-addon form-group">
                 {{ Form::text('name', null, ['class' => 'form-control', 'placeholder'=>'Full Name','required'=>'required']) }}
                        {!! $errors->first('name', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                          {{ Form::text('contact_num', null, ['class' => 'form-control', 'placeholder'=>'Contact No','required'=>'required']) }}
                        {!! $errors->first('contact_num', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                         {{ Form::text('email', null, ['class' => 'form-control', 'placeholder'=>'Your Email','required'=>'required']) }}
                {!! $errors->first('email', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                         {!! Form::select('country_id', $countries->pluck('name', 'name'), null, array('class'=>'form-control','placeholder'=>'Choose Country','required'=>'required')) !!}
          {!! $errors->first('country_id', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="left-inner-addon form-group">
                           {{ Form::textarea('enquiry', null, ['class' => 'form-control', 'placeholder'=>'Type Your Enquiry Here','required'=>'required']) }}
                        {!! $errors->first('enquiry', '<div class="err">:message</div>') !!}
                        </div><!--form-group-->

                        <div class="captche form-group">
                          <span>9+1= </span> <input type="text" class="form-control" placeholder="Enter above code" />
                        </div>

                        <div class="input-btn">
                          <input class="btn" type="submit" value="submit">
                        </div>
                 {{ Form::close() }}
                  </div>
                </div><!--right-content-title-->


              </div><!--content-left-->
            </div>
          </div>
        </div>

      </div><!--content-block-->

    </main>
@stop