@extends('admin.layout')

@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
            <h2 class="bedcrumb">
                <a href="{!! URL::to('admin/dashboard') !!}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                {!! $bredcrumb !!} 
                                
            </h2>
        
               @if( isset($model) )
   {!! Form::model($model, ['method' => 'PATCH','route' => ['users.update', $model->id], 'files' => true ]) !!}

@else
    {!! Form::open(['route' => 'users.store', 'files' => true ]) !!}
@endif
                <!-- left form -->
                <aside class="Form_box_left">
                <div class="insed_form">
                    <h1 class="form_head">Enter Details</h1>
                    <ul class="form_ul">    

                    <li>
                        <ul class="tw35">
                                <li>Email <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('email', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('email', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>                                               
                    
                        <li>
                            <ul class="tw35">
                                <li>Username <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('username', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('username', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>

                        <li>
                            <ul class="tw35">
                                <li>Password @if(!isset($model))<span class="req">*</span> @endif</li>
                            </ul>

                            <ul class="tw65">
                                <li>
                                    {!! Form::password('password', array('class'=>'fip')) !!}
                                    {!! $errors->first('password', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>

                        <li>
                            <ul class="tw35">
                                <li>Confirm Password @if(!isset($model))<span class="req">*</span> @endif</li>
                            </ul>

                            <ul class="tw65">
                                <li>
                                    {!! Form::password('password_confirmation', array('class'=>'fip')) !!}
                                    {!! $errors->first('password_confirmation', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                        
                        <li>
                            <ul class="tw35">
                                <li>First Name <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('first_name', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('first_name', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                        
                        <li>
                            <ul class="tw35">
                                <li>Last Name</li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('last_name', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('last_name', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                                                
                        @if (isset($model) && $model->image)
                            <li>
                                <ul class="tw35">
                                    <li>Image</li>
                                </ul>
                                
                                <ul class="tw65">
                                    <li>
                                        <span class="checkkkk">{!! Form::checkbox('delete_image', '1') !!} Remove</span>
                                        <img src="{!!asset($model->thumb.$model->image)!!}" alt="{!! $model->first_name !!}" class="image_list" />
                                    </li>
                                </ul>
                            </li>
                        @endif
                        
                        
                        <li>
                            <ul class="tw35">
                                <li>Upload Image <br><span>max-size : 800px * 800px (jpg, png, gif)</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>
                                    {!! Form::file('image', array('class'=>'fip2')) !!}
                                    {!! $errors->first('image', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                        
                         <li>
                            <ul class="tw35">
                                <li>Country <span class="req">*</span></li>
                            </ul>
                            
                            <?php
// dd($countries);
                            // $countrylist = $countries->all();
                            ?>
                            <ul class="tw65">
                                <li> {!! Form::select('country_id', $countries->pluck('name', 'id'), null, array('class'=>'fsl')) !!}
                                    {!! $errors->first('country_id', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                                                
                        <li>
                            <ul class="tw35">
                                <li>Street Address</li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>
                                    {!! Form::textarea('street_address', null, array('class'=>'ftt')) !!}
                                    {!! $errors->first('street_address', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li> 
                        
                        <li>
                            <ul class="tw35">
                                <li>Postcode</li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('postcode', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('postcode', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li> 
                        
                       <?php /*?> <li>
                            <ul class="tw35">
                                <li>Country</li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>
                                    <select class="fsl">
                                        <option>Nepal</option>
                                        <option>Nepal</option>
                                        <option>Tibet</option>
                                    </select>
                                </li>
                            </ul>
                        </li>  <?php */?>                                          
                        
                    </ul>   
                </div>    
                </aside>
                
                <!-- right form -->
                <aside class="Form_box_right">
                <div class="insed_form">
                    <ul class="form_ul2">
                                                                      
                        <h1 class="form_head">Status</h1>
                        <li>                                
                            {!!
                                Form::select('status', array(
                                    '1' => 'Active', 
                                    '0' => 'Unverified',
                                    '2' => 'Suspend'
                                    ),null,array('class'=>'fsl')
                                 )
                            !!}
                        </li>
                        
                        
                        <li class="last_li_form">
                            {!! isset($model) ? Form::submit('Update', array('class'=>'fbt')) : Form::submit('Create', array('class'=>'fbt')) !!}
                            
                        </li>
                        
                    </ul>
                        
                </div>  
                </aside>
            {!! Form::close() !!}
        </div>
        
    </aside>
@stop    