@extends('admin.layout')

@section('search')      
    {!! Form::open(array('url' => 'admin/banner/search', 'class' => 'search_box', 'name'=>'frmSearch')) !!}
        <span class="search_label">             
            {!! Form::text('q', null, array('class'=>'fip', 'placeholder'=>'Search...')) !!}
            {!! Form::submit('', array('class'=>'search_bgg')) !!}            
        </span>    
    {!! Form::close() !!}
@stop 

@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
        
            <h2 class="bedcrumb">
                <a href="{{ url('admin/dashboard') }}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                {!! $bredcrumb !!}       
            </h2>
            
            
           {!! Session::get('message') !!}
                                    
             <div class="button_right"> 
                <a href="{!! url('admin/packages/create') !!}" class="btn-green btn_hv">Create</a>                   
                <div class="btn-group">
                    <div class="btn btn-black" data-toggle="dropdown" data-hover="dropdown"><i class="fa fa-chevron-down"></i>&nbsp;&nbsp;Action</div>
                      <ul class="dropdown-menu">
                            <li><a href="javascript:void(0);" onclick="return actionSubmit('packages/update-status/1');">Activate</a></li>
                            <li><a href="javascript:void(0);" onclick="return actionSubmit('packages/update-status/0');">Deactivate</a></li>
                            <li><a href="javascript:void(0);" onclick="return actionConfirm('packages/delete','Delete');">Delete</a></li>
                      </ul>
                 </div>                                               
                        
             </div>
             
             <div class="button_left">  
                <div class="btn-group">
                  <button class="btn btn-none" data-toggle="dropdown" data-hover="dropdown">Status&nbsp;&nbsp;<i class="fa fa-chevron-down"></i></button>
                  <ul class="dropdown-menu2">
                    <li><a href="{!! URL::to('admin/packages') !!}">Any</a></li>
                    <li><a href="{{ URL::to('admin/packages/status', array('status'=>1)) }}">Active</a></li>
                    <li><a href="{{ URL::to('admin/packages/status', array('status'=>0)) }}">Inactive</a></li>                    
                  </ul>
                </div> 
             </div>                           
            
 {!! $models->links() !!}
 
            <div class="table_holder">
                {!! Form::open(array('id' => 'frmListing')) !!}
                    <table width="100%" border="0" cellspacing="1" cellpadding="0"  align="left" class="table" id="sortable" >
                         <tr class="row1 nodrop nodrag" >                           
                            <td class="hd_td">Title</td>
                             <td class="hd_td">Image</td>
                             <td class="hd_td">Content</td>
                            <td class="hd_td">Created</td>
                            <td class="hd_td">Updated</td>
                            <td class="hd_td">Status</td>
                            <td class="hd_td">{!! Form::checkbox('toggle_check', '', '', array('onclick'=>'toggleSelect();')); !!}</td>
                         </tr>
                        
                         <?php $sort_orders = '';?>
                         <?php $i = 0;?>
                         @foreach ($models as $m)
                            <?php $sort_orders.=$m->sort_order.',';?>
                             <tr class="{!! ($i%2==0) ? 'row2' : 'row1' !!}" id="{!! $m->id !!}">                                
                                 <td>{!! $m->title !!}<a href="{{ route('packages.edit', $m->id) }}"><i class="fa fa-pencil fa_icon"></i></a></td>
                                 <td><img src="{!! asset($m->upload.$m->image)!!}" alt="" class="Image_list" width="100" /></td>
                                  <td>{!! substr($m->content,0,100) !!}</td>
                                 <td>{!! $m->created_at !!}</td>
                                 <td>{!! $m->updated_at !!}</td>
                                 <td>{!! $status[$m->status] !!}</td>                 
                                 <td>{!! Form::checkbox('ids[]', $m->id) !!}</td>
                             </tr>
                             <?php $i++;?>
                         @endforeach 

                          
                    </table>
                {!! Form::close() !!}
                @if(sizeof($models)==0) 
                  
                @endif                
            </div>
  
            {!! $models->links() !!}
        </div>
        <div class="marg10"></div>
    </aside>
@stop

@section('foot')
    @parent
    <script src="{{asset('public/admin/js/jquery.tablednd_0_5.js')}}" type="text/javascript"></script>        
    <script type="text/javascript">
        $(document).ready(function(){
             $('#sortable').tableDnD({
                onDrop: function(table, row) {
                //alert($.tableDnD.serialize());
                $.post("ajax/drag-drop-sorting", {ids_order: $.tableDnD.serialize(), sort_orders:'<?php echo $sort_orders;?>', table:'banners' } );
                }
            }); 
        });
    </script>
@stop