@extends('admin.layout')

@section('head')
	@parent
	<script type="text/javascript" src="../xtras/ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="../xtras/js/jquery.blockUI.js"></script>
@stop 

<meta name="csrf-token" content="{{ csrf_token() }}"
@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
            <h2 class="bedcrumb">
                <a href="{!! url('admin/dashboard') !!}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                {!! $bredcrumb !!}                                 
            </h2>
        
    {!! Form::open(['route' => 'navs.store', 'files'=>true]) !!}
                <!-- left form -->
                <aside class="Form_box_left">
                <div class="insed_form">
                    <h1 class="form_head">Enter Details</h1>
                    <ul class="form_ul">
                    	<li>
                            <ul class="tw35">
                                <li>Parent</li>
                            </ul>
                            
                            <ul class="tw65">
                                <li> 
                                	<?php
									if(isset($model))
									{
										$options=array('0' => 'None') + TreeHelper::selectOptions('navs', $base_id=0, $id=$model->id, $terms=null, $order_by='title', $order='asc');
									}
									else 
									{										
										$options=array('0' => 'None') + TreeHelper::selectOptions('navs', $base_id=0, $id=null, $terms=null, $order_by='title', $order='asc');	
									}
									
									
									?>                                	                                             	
                                    {!!  Form::select('parent_id', $options, $parent_id, array('class'=>'fsl')) !!}
                                   
                                </li>
                            </ul>
                        </li>
                        

                        
                        <li>
                            <ul class="tw35">
                                <li>Type <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li> 
          	
                                    {!!
                                        Form::select('type', array(
                                        	'' => '- - - Select - - -',
                                        	'none' => 'None',                                            
                                            'categories' => 'Categories',
                                            'pages' => 'Pages',
                                            'posts' => ucfirst(POSTS),
                                            'routes' => 'Routes',
                                            'link' => 'Link'                                            
                                            ),null,array('id'=>'type', 'class'=>'fsl', 'onchange'=>'changeType(this.value);')
                                         )
                                    !!}
                                    {!! $errors->first('type', '<div class="err">:message</div>') !!}
                                    
                                </li>
                            </ul>
                        </li>

                        
                        <div id="group"> @include('admin.page.nav_type_partial_a') </div>	
                        
                        <div id="title_section">
                            <li>
                                <ul class="tw35">
                                    <li>Title <span class="req">*</span></li>
                                </ul>
                                
                                <ul class="tw65">
                                    <li>                                	
                                        {!! Form::text('title', null, array('id'=>'title', 'class'=>'fip')) !!}
                                        {!! $errors->first('title', '<div class="err">:message</div>') !!}                                                                                
                                    </li>
                                </ul>
                            </li>
                         </div>
                         
                         <div id="url_section">
                            <li>
                                <ul class="tw35">
                                    <li>Url <span class="req">*</span></li>
                                </ul>
                                
                                <ul class="tw65">
                                    <li>                                	
                                        {!! Form::text('url', null, array('id'=>'url', 'class'=>'fip')) !!}
                                        {!! $errors->first('url', '<div class="err">:message</div>') !!}
                                    </li>
                                </ul>
                            </li>
                        </div> 	
                        
                                                                                                                                              
                        
                    </ul>	
                </div>    
                </aside>
                
                <!-- right form -->
                <aside class="Form_box_right">
                <div class="insed_form">
                    <ul class="form_ul2">                                                                      
                        
                        <h1 class="form_head">Status</h1>
                        <li>                            	
                            {!!
                                Form::select('status', array(
                                    '1' => 'Active', 
                                    '0' => 'Inactive'
                                    ),null,array('class'=>'fsl')
                                 )
                            !!}
                        </li>
                        
                        <h1 class="form_head">
                        		
                        		<span class="checkkkk">{!! Form::radio('target', 1) !!}  Yes</span>
                                <span class="checkkkk">{!! Form::radio('target', 0, true) !!}  No</span>
                                <span class="checkkkk"> {!! NEW_PAGE !!} : </span>
                        </h1>
                        
                        
                            <h1 class="form_head">                                    
                                <span class="checkkkk">{!! Form::radio('dev', 1) !!}  Yes</span>
                                <span class="checkkkk">{!! Form::radio('dev', 0, true) !!}  No</span>
                                <span class="checkkkk"> Developer : </span>
                            </h1>
                       
                        
                        <li class="last_li_form">
                        	{!! isset($model) ? Form::submit('Update', array('class'=>'fbt')) : Form::submit('Create', array('class'=>'fbt')) !!}
                        	
                        </li>
                        
                    </ul>
                        
                </div> 	
                </aside>
            {!! Form::close() !!}
        </div>
        
    </aside>

@stop 

@section('foot')
	@parent

    <script type="text/javascript">

    $.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

		var type = document.getElementById('type').value;
		if(type=='none' || type=='routes' || type=='link')
		{
			document.getElementById('title_section').style.display='inline';
            if(type=='none')
            {
                document.getElementById('url').value='';
                document.getElementById('url_section').style.display='none';
            }
            else if(type=='routes' || type=='link')
            {
                document.getElementById('url_section').style.display='inline';
            }
		}
		else 
		{
			document.getElementById('title').value='';
			document.getElementById('title_section').style.display='none';
            document.getElementById('url').value='';
            document.getElementById('url_section').style.display='none';
		}
		


		function changeType(type)
		{			
			$.blockUI({ css: { 
				border: 'none', 
				padding: '15px', 
				backgroundColor: '#000', 
				'-webkit-border-radius': '10px', 
				'-moz-border-radius': '10px', 
				opacity: .5, 
				color: '#fff' 
			},
			message: '<h1>Please Wait...</h1>'
			});


            if(type=='none' || type=='routes' || type=='link')
            {
                document.getElementById('title_section').style.display='inline';
                if(type=='none')
                {
                    document.getElementById('url').value='';
                    document.getElementById('url_section').style.display='none';
                }
                else if(type=='routes' || type=='link')
                {
                    document.getElementById('url_section').style.display='inline';
                }
            }
            else
            {
                document.getElementById('title').value='';
                document.getElementById('title_section').style.display='none';
                document.getElementById('url').value='';
                document.getElementById('url_section').style.display='none';
            }

			$.post("navs/change-type-create", {type:type} , function(data)
			{
			  if (data != '' || data != undefined || data != null) 
			   {	 
				  $('#group').html(data);
				  setTimeout($.unblockUI); 
			   }
			});			
		}
		
		
		function updateRoute(route)
		{		
			document.getElementById('url').value=route;								
		}
		
		function searchByTitle(type, search_txt)
		{		
			if(!search_txt)
			{
				document.getElementById('url').value='';
				setTimeout($.unblockUI); 				
			}
						
			$.post("navs/search-by-title-create", {type:type, search_txt:search_txt} , function(data)
			{
			  if (data != '' || data != undefined || data != null) 
			   {	 
				  $('#search_result').html(data);
			   }
			});			
		}
	</script>
      <!-- <script src="{{asset('public/admin/js/jquery-latest.min.js')}}"></script>  -->
@stop   