@extends('admin.layout')

@section('head')
    @parent
    <script type="text/javascript" src="{{asset('public/assets/ckeditor/ckeditor.js')}}"></script>
@stop 


@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
            <h2 class="bedcrumb">
                <a href="{{ url('admin/dashboard') }}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                 {!! $bredcrumb !!}
            </h2>
        
            
                                @if( isset($model) )
   {!! Form::model($model, ['method' => 'PATCH','route' => ['blogs.update', $model->id], 'files' => true ]) !!}

@else
    {!! Form::open(['route' => 'blogs.store', 'files' => true ]) !!}
@endif
                <!-- left form -->
                <aside class="Form_box_left">
                <div class="insed_form">
                    <h1 class="form_head">Enter Details</h1>
                    <ul class="form_ul">
                        <li>
                            <ul class="tw35">
                                <li>Title <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                    
                                    {!! Form::text('title', null, array('class'=>'fip')) !!}
                                    {!! $errors->first('title', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>

                   @if (isset($model) && $model->image)
                            <li>
                                <ul class="tw35">
                                    <li>Image</li>
                                </ul>
                                
                                <ul class="tw65">
                                    <li>
                                        <span class="checkkkk">{!! Form::checkbox('delete_image', '1') !!} Remove</span>
                                        <img src="{!! asset($model->thumb.$model->image) !!}" alt="{!! $model->title !!}" class="image_list" />
                                    </li>
                                </ul>
                            </li>
                        @endif
                        
                        
                        <li>
                            <ul class="tw35">
                                <li>Upload Image
                                <br><span>max-size : 800px * 800px (jpg, png, gif)</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>
                                    {!! Form::file('image', array('class'=>'fip2')) !!}
                                    {!! $errors->first('image', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                        
                        <li>
                            <div class="editor_box">
                                {!! Form::textarea('content', null, array('class'=>'ckeditor')) !!}
                                {!! $errors->first('content', '<div class="err">:message</div>') !!}
                            </div>
                        </li>

                        
                    </ul>   
                </div>    
                </aside>
                
                <!-- right form -->
                <aside class="Form_box_right">
                <div class="insed_form">
                    <ul class="form_ul2">

                        <h1 class="form_head">Meta Title</h1>
                        <li>
                            {!! Form::text('meta_title', null, array('class'=>'fip')) !!}
                            {!! $errors->first('meta_title', '<div class="err">:message</div>') !!}
                        </li>

                        <h1 class="form_head">Meta Keywords</h1>
                        <li>
                            {!! Form::textarea('meta_keywords', null, array('class'=>'ftt')) !!}
                            {!! $errors->first('meta_keywords', '<div class="err">:message</div>') !!}
                        </li>

                        <h1 class="form_head">Meta Description</h1>
                        <li>
                            {!! Form::textarea('meta_description', null, array('class'=>'ftt')) !!}
                            {!! $errors->first('meta_description', '<div class="err">:message</div>') !!}
                        </li>
                                                                     
                        <h1 class="form_head">Status</h1>
                        <li>                                
                            {!!
                                Form::select('status', array(
                                    '1' => 'Active', 
                                    '0' => 'Inactive'
                                    ),null,array('class'=>'fsl')
                                 )
                            !!}
                        </li>
                        
                        <li class="last_li_form">
                            {!! isset($model) ? Form::submit('Update', array('class'=>'fbt')) : Form::submit('Create', array('class'=>'fbt')) !!}
                            
                        </li>
                        
                    </ul>
                        
                </div>  

           
                </aside>
            {!! Form::close() !!}
        </div>
        
    </aside>
@stop

