<?php

/*
|--------------------------------------------------------------------------
| Application & Route Filters
|--------------------------------------------------------------------------
|
| Below you will find the "before" and "after" events for the application
| which may be used to do any work before or after a request into your
| application. Here you may also register your custom route filters.
|
*/

App::before(function($request)
{
	// Our own method to defend XSS attacks globally.
	//Common::globalXssClean();
});


App::after(function($request, $response)
{
	//
});

/*
|--------------------------------------------------------------------------
| Authentication Filters
|--------------------------------------------------------------------------
|
| The following filters are used to verify that the user of the current
| session is logged into this application. The "basic" filter easily
| integrates HTTP Basic authentication for quick, simple checking.
|
*/

Route::filter('auth', function()
{
	if (Auth::guest()) return Redirect::guest('login');
});


Route::filter('auth.basic', function()
{
	return Auth::basic();
});

/*
|--------------------------------------------------------------------------
| Guest Filter
|--------------------------------------------------------------------------
|
| The "guest" filter is the counterpart of the authentication filters as
| it simply checks that the current user is not logged in. A redirect
| response will be issued if they are, which you may freely change.
|
*/

Route::filter('guest', function()
{
	if (Auth::check()) return Redirect::to('/');
});

/*
|--------------------------------------------------------------------------
| CSRF Protection Filter
|--------------------------------------------------------------------------
|
| The CSRF filter is responsible for protecting your application against
| cross-site request forgery attacks. If this special token in a user
| session does not match the one given in this request, we'll bail.
|
*/

Route::filter('csrf', function()
{
	if (Session::token() != Input::get('_token'))
	{
		throw new Illuminate\Session\TokenMismatchException;
	}
});

Route::filter('admin', function()
{
    if (Auth::viaRemember())
	{				
		if(!Auth::getUser()->admin)
		{
			Auth::logout();
			return Redirect::to('control')->with('message','<div class="warning">Please Login to Proceed.</div>');
		}					
		
		define('USER_ID', Auth::getUser()->id, TRUE);
		define('USER_FIRST_NAME', Auth::getUser()->first_name, TRUE);
		define('DEVELOPER', Auth::getUser()->dev, TRUE);

	}		
	else 
	{
		if(!Auth::check() || !Auth::user()->admin)
		{			
			Auth::logout();	
			return Redirect::to('control')->with('message','<div class="warning">Please Login to Proceed.</div>');				
		}
		define('USER_ID', Auth::user()->id, TRUE);	
		define('USER_FIRST_NAME', Auth::user()->first_name, TRUE);	
		define('DEVELOPER', Auth::user()->dev, TRUE);	

	}
});

Route::when('admin/*', 'admin');
















