<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use App\Models\Category;
use App\Models\Category_Post;
use App\Models\Post;
use App\Models\Comment;
use DbHelper;
use Str;
use Image;
use Carbon;
use File;
use DB;
class Post extends Model
{

    protected $table = 'posts';	
	protected $guarded = array('id', 'slug', 'author_id', 'categories','route','image','featuredimage', 'delete_image', 'fields_values', 'departures_costs', 'created_at', 'updated_at');
	// public $upload=	'public/uploads/post_galleries/';
	// public $thumb=	'public/uploads/post_galleries/thumbs/';
	public $featured='public/uploads/featured/';
	public $featuredthumb='public/uploads/featured/thumbs/';
	public $routes= 'public/uploads/route/';
	public $routethumb='public/uploads/route/thumbs/';
	
	public function categories()
    {
        return $this->belongsToMany('App\Models\Category');
    }
	
		public function categories_posts()
    {
        return $this->belongsToMany('App\Models\Category', 'category_post');
    }
    
     public function post_testimonial()
    {
    	return $this->belongsToMany('App\Models\Testimonial', 'post_testimonial','post_id', 'testimonial_id');
    }
    
	public function author()
    {
        return $this->belongsTo('App\Models\User', 'author_id');
    }
	public function comments()
    {
        return $this->hasMany('App\Models\Comment', 'post_id');
    }
	
	
	public function gallery()
    {
        return $this->hasMany('App\Models\PostGallery' , 'parent_id');
    }
	
	public static function createModel()
	{

		// dd(Input::file('featuredimage'));

		$current_time = Carbon\Carbon::now()->toDateTimeString();
		$model = new Post(Input::all());
		if($file = Input::hasFile('routemap')) {
            
            $file = Input::file('routemap') ;			
			$extension=Input::file('routemap')->getClientOriginalExtension();
			$route=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('routemap')->move($model->routes, $route);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->routes.$route)->resize(250, 160)->save($model->routethumb.$route);
			}
			$model->routemap= $route;
		}
		
		 if($file = Input::hasFile('featuredimage')) {
            
            $file = Input::file('featuredimage') ;
            
           $extension=Input::file('featuredimage')->getClientOriginalExtension();
           $featuredimage=Str::slug(Input::get('title')).time().'.'.$extension;
            Input::file('featuredimage')->move($model->featured, $featuredimage);

     if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->featured.$featuredimage)->resize(250, 160)->save($model->featuredthumb.$featuredimage);
			}

            $model->featuredimage = $featuredimage;
		}
		// $model->author_id = USER_ID;		
		$model->slug = Str::slug(Input::get('title'));
		$model->fields_values = serialize(Input::get('fields_values'));
		$model->departures_costs = serialize(Input::get('departures_costs'));
		$model->sort_order = DbHelper::nextSortOrder($model->table);
		$model->save();	
		$model->categories()->sync(Input::get('categories'));
		$pid = DB::table('posts')->where('slug',Str::slug(Input::get('title')))->first();
		
	}
	public static function updateModel($id)
	{		
		
			$current_time = Carbon\Carbon::now()->toDateTimeString();
		 $inputs = Input::all();		
		$model = Post::find($id);
		
		// $model = Album::find(Input::get('id'));
		$model->fill($inputs);
		
		/** end fo route image **/
		/** featured images **/
		if (Input::hasFile('featuredimage'))
		{			
		
			if($model->featuredimage)
			{ //echo public_path().'"\"'.$model->featuredthumb.$model->featuredimage;die();

	
				File::delete($model->featured.$model->featuredimage);
				File::delete($model->featuredthumb.$model->featuredimage);
			}
			$extension=Input::file('featuredimage')->getClientOriginalExtension();
			$featured=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('featuredimage')->move($model->featured, $featured);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->featured.$featured)->resize(250, 160)->save($model->featuredthumb.$featured);
			}
			$model->featuredimage= $featured;
		}


			if (Input::hasFile('routemap'))
		{			
		
			if($model->routemap)
			{
				File::delete(public_path().'/'.$model->routes.$model->routemap);
				File::delete(public_path().'/'.$model->routethumb.$model->routemap);
			}
			$extension=Input::file('routemap')->getClientOriginalExtension();
			$route=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('routemap')->move($model->routes, $route);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->routes.$route)->fit(768, 460)->save($model->routethumb.$route);
			}
			$model->routemap= $route;
		}
		/** end fo route image **/
		$model->slug = Str::slug(Input::get('title'));
		$model->fields_values = serialize(Input::get('fields_values'));
		$model->departures_costs = serialize(Input::get('departures_costs'));
		$model->save();	
		$model->categories()->sync(Input::get('categories'));
		
		
		Nav::where('type',$model->table)
			->where('type_id',$model->id)
            ->update(array('url' => POST.'/'.$model->slug));
	}

	
	public static function deleteModel()
	{		
		$models=Post::whereIn('id', Input::get('ids'))->get(array('id', 'image','routemap'));
		foreach($models as $m)
		{
	
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
			File::delete(public_path().'/'.$m->routes.$m->routemap);
			File::delete(public_path().'/'.$m->routethumb.$m->routemap);
			File::delete(public_path().'/'.$m->featured.$m->featuredimage);
			File::delete(public_path().'/'.$m->featuredthumb.$m->featuredimage);
			Nav::deleteLinkModels($m->table, $m->id);
			Comment::deleteModelByPost($m->id);
			PostGallery::deleteModelByParent($m->id);			
			$m->categories()->detach();
		}		
		return Post::whereIn('id', Input::get('ids'))->delete();				
	}
		
	public static function deleteModelByUser($id)
	{		
		$models=Post::where('author_id', $id)->get(array('id', 'image','routemap'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
			File::delete(public_path().'/'.$m->routes.$m->routemap);
			File::delete(public_path().'/'.$m->routethumb.$m->routemap);
			File::delete(public_path().'/'.$m->featured.$m->featuredimage);
			File::delete(public_path().'/'.$m->featuredthumb.$m->featuredimage);
			Nav::deleteLinkModels($m->table, $m->id);
			Comment::deleteModelByPost($m->id);
			PostGallery::deleteModelByParent($m->id);
			$m->categories()->detach();
		}
		Post::where('author_id', $id)->delete();					
	}

	

	
}