<?php

namespace App\Models;
use Illuminate\Support\Facades\Input;
use Illuminate\Database\Eloquent\Model;
use Str;
use Image;
use File;
use DbHelper;
class Page extends Model
{
   protected $table = 'pages';	
	protected $guarded = array('id', 'slug', 'image', 'delete_image', 'created_at', 'updated_at', 'sort_order');
	public $upload=	'public/uploads/pages/';
	public $thumb=	'public/uploads/pages/thumbs/';

	public function childs()
	{
		return $this->hasMany('App\Models\Page' , 'parent_id');
	}

    public function gallery()
    {
        return $this->hasMany('App\Models\PageGallery' , 'parent_id');
    }
	
	public static function createModel()
	{
		$model = new Page(Input::all());	
		if (Input::hasFile('image'))
		{			
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(800, 535)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
		$model->slug = Str::slug(Input::get('title'));
		$model->sort_order = DbHelper::nextSortOrder($model->table);
		$model->save();
	}
	
	public static function updateModel($id)
	{		
		$inputs = Input::all();			
		$model = Page::find($id);
		$model->fill($inputs);
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(800, 535)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
		else if(Input::get('delete_image'))
		{
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$model->image = '';
		}
		
		$model->slug = Str::slug(Input::get('title'));
		$model->save();	
		
		//update menu(if exists)
		Nav::where('type',$model->table)
			->where('type_id',$model->id)
			->update(array('url' => $model->slug));

	}

	public static function deleteModel()
	{
		$models=Page::whereIn('id', Input::get('ids'))->get(array('id', 'image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
			Nav::deleteLinkModels($m->table, $m->id);
            PageGallery::deleteModelByParent($m->id);
			$childs=Page::where('parent_id', $m->id)->count();
			if($childs>0)Page::deleteChildModels($m->id);
		}
		return Page::whereIn('id', Input::get('ids'))->delete();
	}

	public static function deleteChildModels($id)
	{
		$models=Page::where('parent_id', $id)->get(array('id', 'image'));
		if(sizeof($models)>0)
		{
			foreach($models as $m)
			{
				File::delete(public_path().'/'.$m->upload.$m->image);
				File::delete(public_path().'/'.$m->thumb.$m->image);
				Page::where('id', $m->id)->delete();
				Nav::deleteLinkModels($m->table, $m->id);
                PageGallery::deleteModelByParent($m->id);
				$childs=Page::where('parent_id', $m->id)->count();
				if($childs>0)Page::deleteChildModels($m->id);
			}
		}
	}
}