<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use App\Models\Page;
use DB;
use TreeHelper;
use DbHelper;
use App\Models\Category;
class Nav extends Model
{
	protected $table = 'navs';	
	protected $guarded = array('id', 'created_at', 'updated_at', 'sort_order', 'search_txt');
	
	public function childs()
    {
        return $this->hasMany('App\Models\Nav' , 'parent_id');
    }
    public function categories()
    {
        return $this->hasMany('App\Models\Category');
    }
	public static function createModel()
	{	
			if(in_array(Input::get('type'), array('pages','categories','posts')))
		{
			
			foreach(Input::get('type_id') as $type_id)
			{			
				$model = new Nav(Input::all());								
				$data= DB::table(Input::get('type'))->where('id', $type_id)->take(1)->first(array('slug', 'title'));
				switch (Input::get('type')) 
				{
					case "categories":
						$model->url='category/'.$data->slug;
						break;
					case "pages":
						$model->url='page/'.$data->slug;
						break;
					case "posts":
						$model->url='trip/'.$data->slug;
						break;
				}
				$model->type_id = $type_id;
				$model->title =	$data->title;
				 $model->sort_order = DbHelper::nextSortOrder($model->table);						
				$model->save();	
			}
		}
		else
		{
			$model = new Nav(Input::all());
			$model->sort_order = DbHelper::nextSortOrder($model->table);
			$model->save();
		}
	}
	
	
	public static function updateModel($id)
	{		
		
			$inputs = Input::all();	

		$model = Nav::find($id);	
		
		// $model = Album::find(Input::get('id'));
		$model->fill($inputs);

            if(in_array(Input::get('type'), array('pages','categories','posts')))
            {
                $data= DB::table(Input::get('type'))->where('id', Input::get('type_id'))->take(1)->first(array('slug', 'title'));
                switch (Input::get('type'))
                {
                    case "categories":
                        $model->url='category/'.$data->slug;
                        break;
                    case "pages":
			$model->url='page/'.$data->slug;
                        break;
                    case "posts":
                      $model->url='trip/'.$data->slug;
                        break;
                }
            }

            //$model->title =	$data->title;
			$model->save();	


	}
	
/*	public static function updateModel()
	{		
		$data = Input::all();			
		$model = Nav::find(Input::get('id'));
		$model->fill($data);	
		$model->save();	
	}*/
		
	public static function deleteModel()
	{		
		$models=Nav::whereIn('id', Input::get('ids'))->get(array('id'));
		foreach($models as $m)
		{
			$childs=Nav::where('parent_id', $m->id)->count();
			if($childs>0)Nav::deleteChildModels($m->id);
		}	
		Nav::whereIn('id', Input::get('ids'))->delete();		
	}
	
	public static function deleteLinkModels($type, $id)
	{		

		$models=Nav::where('type', $type)->where('type_id', $id)->get();
		if(sizeof($models)>0)
		{
			foreach($models as $m)
			{
				Nav::where('id', $m->id)->delete();
				$childs=Nav::where('parent_id', $m->id)->count();
				if($childs>0)Nav::deleteChildModels($m->id);
			}
		}
	}
	
	public static function deleteChildModels($id)
	{
		$models=Nav::where('parent_id', $id)->get(array('id'));
		if(sizeof($models)>0)
		{
			foreach($models as $m)
			{				
				Nav::where('id', $m->id)->delete();
				$childs=Nav::where('parent_id', $m->id)->count();
				if($childs>0)Nav::deleteChildModels($m->id);
			}
		}
	}
}