<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use App\Models\Gallery;
use Image;
use File;
use Str;
use DbHelper;
class Gallery extends Model
{
    protected $table = 'galleries';	
	public $upload=	'public/uploads/galleries/';
	public $thumb=	'public/uploads/galleries/thumbs/';	

	
	public function album()
    {
        return $this->belongsTo('App\Models\Album', 'parent_id');
    }
	

	public static function createModel($title, $image)
	{		
		$model = new Gallery();	
		$model->parent_id=Input::get('parent_id');
		$model->title=$title;
		$model->image=$image;	
		$model->status=Input::get('status');
		$model->sort_order = DbHelper::nextSortOrder($model->table);				
		$model->save();	
		
	}
	
	public static function updateModel()
	{		
			
		$model = Gallery::find(Input::get('id'));
		
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete(public_path().'/'.$model->upload.$model->image);
				File::delete(public_path().'/'.$model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(350, 263)->save($model->thumb.$image);
			}
			$model->image = $image;
		}

		$model->title=Input::get('title');	
		$model->status=Input::get('status');		
		$model->save();					
	}
	
	public static function deleteModel()
	{				
		$models=Gallery::whereIn('id', Input::get('ids'))->get(array('image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return Gallery::whereIn('id', Input::get('ids'))->delete();						
	}
	
	public static function deleteModelByParent($id)
	{	
		$models=Gallery::where('parent_id', $id)->get(array('id', 'image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return Gallery::where('parent_id', $id)->delete();						
	}
	
}