<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Comment;
use App\Models\Post;
use Illuminate\Support\Facades\Input;
use App\Models\User;
class Comment extends Model
{
    protected $table = 'comments';	
	protected $guarded = array('id', 'user_id', 'created_at', 'updated_at');

	
	public function post()
    {
        return $this->belongsTo('App\Models\Post', 'post_id');
    }
	
	public function user()
    {
        return $this->belongsTo('App\Models\User');
    }
	
	public static function createModel()
	{
		$model = new Comment(Input::all());	
		$model->user_id = USER_ID;						
		$model->save();	
	}
	
	public static function updateModel($id)
	{		
       $inputs = Input::all();		
		$model = Comment::find($id);	
		
		// $model = Album::find(Input::get('id'));
		$model->fill($inputs);	
		$model->save();	
	}
	
	
	public static function deleteModel()
	{		
		$models=Comment::whereIn('id', Input::get('ids'))->get(array('id'));
		foreach($models as $m)
		{
			$childs=Comment::where('parent_id', $m->id)->count();
			if($childs>0)Comment::deleteChildModels($m->id);
		}	
		return Comment::whereIn('id', Input::get('ids'))->delete();		
	}
	
	public static function deleteModelById($id)
	{		
		Comment::where('id', $id)->delete();
		$childs=Comment::where('parent_id', $id)->count();	
		if($childs>0)Comment::deleteChildModels($id);			
	}
	
	public static function deleteModelByPost($id)
	{
		Comment::where('post_id', $id)->delete();
		$childs=Comment::where('parent_id', $id)->count();	
		if($childs>0)Comment::deleteChildModels($id);	
	}
	
	public static function deleteChildModels($id)
	{
		$models=Comment::where('parent_id', $id)->get(array('id'));
		if(sizeof($models)>0)
		{
			foreach($models as $m)
			{				
				Comment::where('id', $m->id)->delete();
				$childs=Comment::where('parent_id', $m->id)->count();
				if($childs>0)Comment::deleteChildModels($m->id);
			}
		}
	}
	
	public static function deleteModelByUser($id)
	{
		Comment::where('user_id', $id)->delete();
		$childs=Comment::where('parent_id', $id)->count();	
		if($childs>0)Comment::deleteChildModels($id);			
	}
}