<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Str;
use DbHelper;
use Image;
use File;
class Category extends Model
{
    protected $table = 'categories';	
	protected $guarded = array('id', 'slug', 'image', 'delete_image', 'created_at', 'updated_at', 'sort_order');
	public $upload=	'public/uploads/categories/';
	public $thumb=	'public/uploads/categories/thumbs/';
	
	public function childs()
    {
        return $this->hasMany('App\Models\Category' , 'parent_id');
    }
	
	public function posts()
    {
        return $this->belongsToMany('App\Models\Post', 'category_post', 'category_id', 'post_id');
    }
	
	public static function createModel()
	{
		$model = new Category(Input::all());
// dd($model);
		if (Input::hasFile('image'))
		{			
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);

			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(1200, 426)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
	
		$model->slug = Str::slug(Input::get('title'));
		$model->sort_order = DbHelper::nextSortOrder($model->table);						
		$model->save();	
	}
	
	public static function updateModel($id)
	{
		$inputs = Input::all();		

		// dd($id);	

		$model = Category::find($id);
		// dd($model);
		$model->fill($inputs);
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(1200, 426)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
		else if(Input::get('delete_image'))
		{
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$model->image = '';
		}
		$model->slug = Str::slug(Input::get('title'));
		$model->save();	
		
		//update menu(if exists)
		Nav::where('type',$model->table)
			->where('type_id',$model->id)
            ->update(array('url' => 'category/'.$model->slug));
	}

	
	
	public static function deleteModel()
	{		
		$models=Category::whereIn('id', Input::get('ids'))->get(array('id', 'image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
			$m->posts()->detach();
			Nav::deleteLinkModels($m->table, $m->id);
			$m->posts()->detach();
			$childs=Category::where('parent_id', $m->id)->count();			
			if($childs>0)Category::deleteChildModels($m->id);			
		}	
		return Category::whereIn('id', Input::get('ids'))->delete();		
	}



	public static function deleteChildModels($id)
	{
		$models=Category::where('parent_id', $id)->get(array('id', 'image'));
		if(sizeof($models)>0)
		{
			foreach($models as $m)
			{
				File::delete(public_path().'/'.$m->upload.$m->image);
				File::delete(public_path().'/'.$m->thumb.$m->image);
				$m->posts()->detach();
				Category::where('id', $m->id)->delete();
				Nav::deleteLinkModels($m->table, $m->id);
				$m->posts()->detach();
				$childs=Category::where('parent_id', $m->id)->count();
				if($childs>0)Category::deleteChildModels($m->id);
			}
		}
	}


}