<?php

namespace App\Http\Controllers\frontend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\SiteSetting;
use App\Models\Nav;
use App\Models\Banner;
use App\Models\Post;
use App\Models\Category;
use App\Models\Testimonial;
use BredcrumpHelper;
use App\Models\Page;
use TreeHelper;
use App\Models\Country;
class TripsController extends Controller
{
     private $title='Trips';

 public function index(){

$data['bredcrumb'] = ABS.$this->title;
$data['site_setting'] = SiteSetting::all();
$data['headermenu'] = Nav::all();

$data['testimonials'] = Testimonial::orderBy('id', 'desc')->take(5)->get();

// $data['bredcrumb'] = BS.$data['model']->title;

$data['trips']=Banner::where('status', 1)->orderBy('sort_order', 'asc')->take(1)->get();

    	return view('page.trip', $data);
    }

public function getCategory($slug)

	{

 $data['model'] = Category::with(array('childs' => function($query)

{		$query->where('status',1);

		$query->orderBy('sort_order','asc');

			}))

			->where('slug', $slug)
 
            ->where('status',1)

            ->firstOrFail();
           

		$data['meta_title'] = $data['model']->meta_title ? $data['model']->meta_title : $data['model']->title;

		$data['meta_keywords'] = $data['model']->meta_keywords;

		$data['meta_description'] = $data['model']->meta_description;	

// 		//bredcrumb
// $data['ourtrips']=Post::where('status', 1)->orderBy('sort_order','asc')->take(1)->get();
// 		$data['bredcrumb'] = BS.link_to('trips', 'Trips');

$id=$data['model']->id;
 $data['ourtrips']=Category::find($id)->posts()->paginate(14);


		$data['bredcrumb'] = BredcrumpHelper::front('categories', $data['model']->id, 'category');

  //     $data['chooseus']=Page::where('slug','why-choose-us')->first();

		$data['site_setting'] = SiteSetting::all();

// 		$data['models'] = Category::find($data['model']->id)->posts()

// 			->where('status', 1)

// 			->orderBy('title', 'asc')
// //->paginate(20);
// 			->get();

			$data['bestselling']=Post::where('best_selling','=',1)->orderBy('duration','asc')->get();


		return View('page.category', $data);

	}



	
	public function getDetail($slug)

	{
	

		$data['model'] = Post::with(array('categories' => function($query)

			{
				
				$query->where('status',1);

				$query->orderBy('sort_order','asc')->get();

			}))
			->with(array('post_testimonial' => function($query)

			{

				$query->where('status',1)->get();

			}))

			->with(array('gallery' => function($query)

			{

				$query->where('status',1);

				$query->orderBy('sort_order','asc')->get();

			}))

			->where('slug', $slug)

			->where('status',1)

			->firstOrFail();
		/* ==============for the facebook share ==========================*/
		if(sizeof($data['model']->gallery)>0){
	 		$data['img_link']=url('/').'/'.$data['model']->gallery[0]->thumb.$data['model']->gallery[0]->image;
		
		}else{
			 $data['img_link']=url('/').'/'.$data['model']->thumb.$data['model']->image;
		}	

		
 $data['countries'] =Country::orderBy('name','asc')->get();
 
             $data['testimonials'] = Testimonial::where('status', 1)->orderBy('id', 'desc')->take(1)->get();

	

		$data['meta_title'] = $data['model']->meta_title ? $data['model']->meta_title : $data['model']->title;

		$data['meta_keywords'] = $data['model']->meta_keywords;

		$data['meta_description'] = $data['model']->meta_description;
		
		
		$post = Post::where('slug', '=', $slug)->first();
// get the related categories id of the $post
$related_category_ids = $post->categories()->pluck('categories.id');
// get the related post of the categories $related_category_ids
$data['related_posts'] = Post::whereHas('categories', function ($q) use($related_category_ids) {
        $q->whereIn('category_id', $related_category_ids);
    })
    ->where('id', '<>', $post->id)
    ->take(8)->get();


$data['site_setting'] = SiteSetting::all(); 
		//bredcrumb

		//$data['bredcrumb'] = BS.link_to('trips', 'Trips');

		BredcrumpHelper::$level=1;//for last item with link

		$data['bredcrumb'] = BredcrumpHelper::front('categories', $data['model']->categories[0]->id, 'category');
		$data['bredcrumb'].=AB.'>';
		$data['bredcrumb'].=AB.$data['model']->title;



		//for related trips

		$ids=TreeHelper::id('categories', $data['model']->categories[0]->id, $terms="status=1", $order_by='sort_order', $order='asc');

		$data['models'] = Post::whereHas('categories', function($query) use ($ids) {

				$query->whereIn('id', $ids);

			})

			->where('id', '!=', $data['model']->id)

			->where('status',1)

			->orderBy('sort_order', 'asc')

			->get();
		$data['bestselling']=Post::where('best_selling','=',1)->orderBy('duration','asc')->get();


		return View('page.trip', $data);

	}
	
    public function postDetail($slug) {
        $data['model'] = Post::with(array('categories' => function($query) {

                        $query->where('status', 1);

                        $query->orderBy('sort_order', 'asc')->get();
                    }))
                ->with(array('post_testimonial' => function($query) {

                        $query->where('status', 1)->get();
                    }))
                ->with(array('gallery' => function($query) {

                        $query->where('status', 1);

                        $query->orderBy('sort_order', 'asc')->get();
                    }))
                ->where('slug', $slug)
                ->where('status', 1)
                ->firstOrFail();
        /* ==============for the facebook share ========================== */
        if (sizeof($data['model']->gallery) > 0) {
            $data['img_link'] = url('/') . '/' . $data['model']->gallery[0]->thumb . $data['model']->gallery[0]->image;
        } else {
            $data['img_link'] = url('/') . '/' . $data['model']->thumb . $data['model']->image;
        }


        $data['countries'] = Country::orderBy('name', 'asc')->get();

        $data['testimonials'] = Testimonial::where('status', 1)->orderBy('id', 'desc')->take(1)->get();


        $data['meta_title'] = $data['model']->meta_title ? $data['model']->meta_title : $data['model']->title;

        $data['meta_keywords'] = $data['model']->meta_keywords;

        $data['meta_description'] = $data['model']->meta_description;

        $post = Post::where('slug', '=', $slug)->first();
// get the related categories id of the $post
$related_category_ids = $post->categories()->pluck('categories.id');
// get the related post of the categories $related_category_ids
$data['related_posts'] = Post::whereHas('categories', function ($q) use($related_category_ids) {
        $q->whereIn('category_id', $related_category_ids);
    })
    ->where('id', '<>', $post->id)
    ->take(8)->get();


        $data['site_setting'] = SiteSetting::all();
        //bredcrumb
        //$data['bredcrumb'] = BS.link_to('trips', 'Trips');

        BredcrumpHelper::$level = 1; //for last item with link

        $data['bredcrumb'] = BredcrumpHelper::front('categories', $data['model']->categories[0]->id, 'category');
        $data['bredcrumb'].=BS . '>';
        $data['bredcrumb'].= BS . $data['model']->title;



        //for related trips

        $ids = TreeHelper::id('categories', $data['model']->categories[0]->id, $terms = "status=1", $order_by = 'sort_order', $order = 'asc');

        $data['models'] = Post::whereHas('categories', function($query) use ($ids) {

                    $query->whereIn('id', $ids);
                })
                ->where('id', '!=', $data['model']->id)
                ->where('status', 1)
                ->orderBy('sort_order', 'asc')
                ->get();
        $data['bestselling'] = Post::where('best_selling', '=', 1)->orderBy('duration', 'asc')->get();


        return View('page.trip', $data);
    }

    
}
