<?php

namespace App\Http\Controllers\frontend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\SiteSetting;
use App\Models\Nav;
use App\Models\Post;
use Mail;
use Session;
use Validator;
use App\Models\Country;
use Redirect;
class BooknowController extends Controller
{
    public function index(){
$data['site_setting'] = SiteSetting::all();
$data['model'] = Post::with('categories')
            ->orderBy('sort_order', 'asc')
            ->first();
       
$data['meta_title'] = $data['model']->meta_title ? $data['model']->meta_title : $data['model']->title;
$data['meta_keywords'] = $data['model']->meta_keywords;
$data['meta_description'] = $data['model']->meta_description;
$data['countries'] =Country::orderBy('name','asc')->get();
        return view('page.booknow', $data);
    }
    
public function postBook(Request $request){

        $rules=array(
            'first_name'=>'required',
        
            'email' =>'required',
            'number'=>'required',
        
            'country_id'=>'required',
            'triptitle'=>'required',
            'arrivaldate' => 'required',
            'departures' => 'required',
            'days'=>'required',
            'hotelcategories'=>'required',
            
            'message'=>'required'
            
            );
        $validator=Validator::make($request->all(),$rules);
        $data  = array(
            'gender'=> $request->gender,
            'first_name' => $request->first_name,
            'middle_name' => $request->middle_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'number' => $request->number,
            'address' => $request->address,
            'country_id' => $request->country_id,
            'triptitle' => $request->triptitle,
            'arrivaldate' => $request->arrivaldate,
            'departures' => $request->departures,
            'days' => $request->days,
            'hotelcategories' => $request->hotelcategories,
            'childperson' => $request->childperson,
            'adultperson' => $request->adultperson,
            'everestflight' => $request->verestflight,
            'interestedin' => $request->interestedin,
            'enquiry' => $request->enquiry,
        
        
            );
            
                Mail::send('emails.booking',$data,function ($message) use ($data){
                $message->from('sales@friendshiptravels.com');
                $message->to('sales@friendshiptravels.com');
                $message->cc('tournepal@gmail.com');
                $message->subject('Tour Booking - '.$data['triptitle']);
            });
            //Mail::send('emails.booking', $data, function ($message) use ($data){
            //$message->from('sales@friendshiptravels.com');
            //$message->to('sales@friendshiptravels.com')->cc('tournepal@gmail.com')->subject($data['triptitle']);
            // $message->napoklme($data['name']);
            //});
        
          // Session::flash('success', 'Your online form has been submitted<br>Thank You for your Booking / Enquire about this trip, We will contact you very shortly....');
        return Redirect::back()->with('message','<div class="error">Your online form has been submitted<br>Thank You for  Booking this trip, We will contact you very shortly....</div>');
    }

}
