<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\AdminUser;
use Redirect;
use Session;
use App\Models\User;
use Illuminate\Support\Facades\Input;

class LoginController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (Auth::viaRemember())
        {
            return Redirect('admin/dashboard');
        }
        return View('admin.login');
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = array(
            "username" => "required|min:3|max:25",
            "password" => "required|min:6|max:18"
        
        );
        
        $validator = Validator::make(Input::all(),$rules);
        
        if ($validator->fails())
        {
            return Redirect('control')->withInput(Input::except('password','captcha'))->with('message','<div class="error">Username / Password / Captcha is Invalid.</div>');
        }
        

        $credentials = array(
            'username' => Input::get('username'), 
            'password' => Input::get('password') , 
            'status' => 1,
            'admin' => 1
        );
        if (Auth::attempt($credentials, (Input::has('remember_me')) ? true : false))
        {
            return Redirect::intended('admin/dashboard');
        }
        else
        {
            return Redirect('control')->withInput(Input::except('password','captcha'))->with('message','<div class="error">Username / Password is Invalid.</div>');
        }
        
        
    }           

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       Session::flush('Session');
        Session::flash('message','Logout successful...');
        return redirect('control');
    }
}
