<?php

namespace App\Http\Controllers;
use Session;
use Illuminate\Http\Request;
use App\Models\Testimonial;
use App\Models\Country;
use Cache;
use Redirect;
use App\Models\Post;
use TreeHelper;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;


class TestimonialController extends Controller
{
    private $controller='admin/testimonials';
    private $rpp =30;//row per page //default-RPP
    private $title='Testimonials';
    private $table='testimonials';
    private $sort_by='sent_at';
    private $sort_order='desc';
    
    private $listing_page='admin.page.testimonials';
    private $create_form='admin.page.testimonial_ae';
    private $update_form='admin.page.testimonial_ae';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                                        
    );  

        public function __construct(){
$this->middleware('cadmin');
}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $data['title'] = $this->title;
        $data['status'] = $this->status;        
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;
        
        
        $data['models'] = Testimonial::orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    
}

public function status($status) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];
        
        $data['models'] = Testimonial::where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */



    public function create()
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
       $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';
         $data['countries'] =Country::orderBy('name','asc')->get();
         $data['posttitles'] = Post::orderBy('id','asc')->take(1000)->get(); 
         // dd($data['posttitles']);  
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $rules = array(
            "name" => "required",
            "email" => "email",     
            "review" => "required", 
              
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Testimonial::createModel();
       
        return Redirect($this->controller)->with('message','<div class="success">1 '.CREATED.'</div>');
        
    

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       $data['title'] = $this->title;

    $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';
      $data['countries'] =Country::orderBy('name','asc')->get();
         $data['posttitles'] = Post::orderBy('id','asc')->get(); 
         // dd($data['posttitles']);

    $data['model'] = Testimonial::find($id);

    $data['post_id'] = Testimonial::all();
    
       $data['post_testimonial_id'] = Testimonial::find($id)->posts()->pluck('post_id')->toArray();;



 return view($this->update_form, $data);
       
       
        
      
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $rules = array(
            "name" => "required",
            "email" => "email",
                        
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        
        Testimonial::updateModel($id);
        return Redirect($this->controller)->with('message');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     public function postUpdateStatus($status) 
    {       
        
        $affected_models = Testimonial::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }
    
     public function destroy()
    {
   // dd(Input::all());
        $affected_models = Testimonial::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.$affected_models.' '.DELETED.'</div>'); 
    }
}
