<?php

namespace App\Http\Controllers;
use Session;
use Illuminate\Http\Request;
use Cache;
use App\Models\Page;
use App\Models\PageGallery;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Redirect;
use BredcrumpHelper;
class PageController extends Controller
{
    private $controller='admin/pages';
    private $rpp =RPP;//row per page //default-RPP
    private $title='Pages';
    private $table='pages';
    private $sort_by='sort_order';
    private $sort_order='asc';

    private $remember_page='page_parent_id';
    
    private $listing_page='admin.page.pages';
    private $create_form='admin.page.page_ae';
    private $update_form='admin.page.page_ae';
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                            
    );  
    public function __construct(){
$this->middleware('cadmin');
}            
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = $this->title;

       Cache::forget($this->remember_page);

        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;

        $data['models'] = Page::with('childs','gallery')

            ->where('parent_id', 0)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
   
}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
       $data['title'] = $this->title;
       $data['parent_id']=Cache::get($this->remember_page)?Cache::get($this->remember_page):null;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';
            
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $rules = array(
            "title" => "required|unique:".$this->table,
           
        );

        $validator = Validator::make(Input::all(),$rules);
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }

        Page::createModel();

        if (Cache::get($this->remember_page))return Redirect($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">1 '.CREATED.'</div>');
        else return Redirect($this->controller)->with('message','<div class="success">1 '.CREATED.'</div>');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
     $data['title'] = $this->title;

        //for return page
        Cache::forever($this->remember_page, $id);

        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= BredcrumpHelper::admin($this->table, $id, $this->controller.'/parent');

        $data['models'] = Page::with('childs','gallery')
            ->where('parent_id', $id)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }
    

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = $this->title;
          $data['parent_id']=null;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';              
        
        $data['model'] = Page::find($id);
        return View($this->create_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        $rules = array(
            "title" => "required",
                       
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }


        Page::updateModel($id);
        if (Cache::get($this->remember_page))return Redirect($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">1 '.UPDATED.'</div>');
        else return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy()
    {
       $affected_models = Page::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.DELETED.'</div>');
    }
    
}
