<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\AdminUser;
use Redirect;
use Session;
use App\Models\User;
use Illuminate\Support\Facades\Input;
class LoginController extends Controller
{
public function index(){
		
		if (Auth::viaRemember())
		{
			return Redirect('admin/dashboard');
		}
		return View('admin.login');
	}


	public function store(Request $request){

		// dd($request);
		$rules = array(
			'username' => 'required',
			'password' => 'required'
			);
		$Validator = Validator::make($request->all(),$rules);
		if($Validator->fails()){
			$messages = $Validator->messages();
			Session::flash('message','Username or password missing...');
			return redirect('control');
		}else{

		if(Auth::attempt(['username' => $request->username,'password' => $request->password])){
			Session::put('sessUser',$request->username);
			return redirect('admin/dashboard');
		}else{
			Session::flash('message','Invalid username or password !');
			return redirect('control');
		}
		
	}
}

	     public function getLogout(){
		
		Session::flush('Session');
		Session::flash('message','Logout successful...');
		return redirect('control');
	}

}
