<?php

namespace App\Http\Controllers;
use Session;
use Illuminate\Http\Request;
use Cache;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use App\Models\Post;
use App\Models\Comment;
class CommentController extends Controller
{
    private $controller='admin/comments';
    private $rpp=RPP;//row per page //default-RPP
    private $title='Comments';
    private $table='comments';
    private $sort_by='id';
    private $sort_order='asc';
    
    private $remember_page='comment_post_id';
    
    private $listing_page='admin.page.comments';
    private $listing_page_by_post='admin.page.comments_by_post';
    private $update_form='admin.page.comment_e';
    
    private $status = array(
        '0'=>'<span class="deem">Pending</span>', 
        '1'=>'<span class="green">Active</span>',
        '2'=>'<span class="red">Inactive</span>'                                        
    );   

    public function __construct(){
$this->middleware('cadmin');
}            
       
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $data['title'] = $this->title;
        $data['status'] = $this->status;    
        
        Cache::forget($this->remember_page);            
        
        //bredcrumb             
        $data['bredcrumb'] = ABS.$this->title;
      
        $data['models'] = Comment::with('post','user')
            ->orderBy('id', 'desc')
            ->paginate($this->rpp);

        return View($this->listing_page, $data);
    
}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       $data['title'] = $this->title;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';              
                
        $data['model'] = Comment::find($id);
        return View($this->update_form, $data);
    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
       $rules = array(
            "comment" => "required",            
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Comment::updateModel($id);
            
        if (Cache::get($this->remember_page))return Redirect::to($this->controller.'/post/'.Cache::get($this->remember_page))->with('message','<div class="success">1 '.UPDATED.'</div>');  
        else return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
