<?php

namespace App\Http\Controllers;
use App\Custom\DbHelper;
use Illuminate\Http\Request;
use Cache;
use App\Models\Comment;
use App\Models\Category;
use Redirect;
use Session;
use BredcrumpHelper;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
class CategoryController extends Controller
{
  
    private $controller='admin/categories';
    private $rpp=RPP;//row per page //default-RPP
    private $title='Categories';
    private $table='categories';
    private $sort_by='sort_order';
    private $sort_order='asc';
    
    private $remember_page='category_parent_id';
    
    private $listing_page='admin.page.categories';
    private $create_form='admin.page.category_ae';
    private $update_form='admin.page.category_ae';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                            
    );  

public function __construct(){
$this->middleware('cadmin');
}
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
   $data['title'] = $this->title;
        $data['status'] = $this->status;
      
        Cache::forget($this->remember_page);    
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;
          
        $data['models'] = Category::with('childs')
            
            ->whereIn('parent_id', array(0, 1))
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
            // dd($data);
        return View($this->listing_page, $data);
  
}
          
 
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    $data['title'] = $this->title;
       $data['parent_id']=Cache::get($this->remember_page)?Cache::get($this->remember_page):null;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';
        return View($this->create_form, $data);
    }
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
      // dd($request);
    $rules = array(
            "title" => "required|unique:".$this->table,
            "image" => "required",
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Category::createModel();
        
        if (Cache::get($this->remember_page))return Redirect($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">1 '.CREATED.'</div>');  
        else return Redirect($this->controller)->with('message','<div class="success">1 '.CREATED.'</div>');
        
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function status($status) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;
        
        Cache::forget($this->remember_page);                
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];
        
        $data['models'] = Category::with('childs')
            ->where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);

        return View::make($this->listing_page, $data);
    }
    public function show($id)
    {
            
        $data['title'] = $this->title;
        $data['status'] = $this->status;
        
        //for return page
        Cache::forever($this->remember_page, $id);              
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);      
        $data['bredcrumb'].= BredcrumpHelper::admin($this->table, $id, $this->controller.'/category');      
        
        $data['models'] = Category::with('childs','posts')
            ->where('parent_id', $id)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);


            // dd('getcategory');
        return View($this->listing_page, $data);
    

}
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
           $data['title'] = $this->title;
        
      $data['parent_id']=null;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';
        
        $data['model'] = Category::find($id);   
       
        
        return View($this->create_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update( $id)
    {
        // dd(Input::get('id')) ;
       $rules = array(
            "title" => "required"
                         
        );
       
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Category::updateModel($id);
        
        if (Cache::get($this->remember_page))return Redirect::to($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">1 '.UPDATED.'</div>');  
        else return Redirect::to($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function postUpdateStatus($status) 
    {       
        // dd(Input::all());
        $affected_models = Category::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }
    public function destroy()
    {
        // dd(Input::all());

     $affected_models = Category::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.DELETED.'</div>');  
    }
    
}
