<?php

namespace App\Http\Controllers;
use App\Models\Banner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Redirect;
use Session;
class BannerController extends Controller
{
  
    private $controller='admin/banners';
    private $rpp=RPP;//row per page //default-RPP
    private $title='Banners';
    private $table='banners';
    private $sort_by='sort_order';
    private $sort_order='asc';
    
    private $listing_page='admin.page.banners';
    private $create_form='admin.page.banner_ae';
    private $update_form='admin.page.banner_ae';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                                        
    );              
    
    public function __construct(){
$this->middleware('cadmin');
} 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

       $data['title'] = $this->title;
       $data['status'] = $this->status;     
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;

        
        $data['models'] = Banner::orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    


}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       $data['title'] = $this->title;
        
       $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';
       
        
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $rules = array(
            "title" => "required|unique:".$this->table,
            "image" => "required",       
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Banner::createModel();
        return Redirect($this->controller)->with('message');
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
    
     */
   public function status($status) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];
        
        $data['models'] = Banner::where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }

    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       $data['title'] = $this->title;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';
        
        
        
        $data['model'] = Banner::find($id);
        return View($this->update_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        // dd($id);
        $rules = array(
            "title" => "required"               
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        
        Banner::updateModel($id);
        return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function postUpdateStatus($status) 
    {       
        
        $affected_models = Banner::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }
    public function destroy()
    {
        $affected_models = Banner::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.$affected_models.' '.DELETED.'</div>'); 
    }
}
