@extends('admin.layout')

@section('search')  	
    {!! Form::open(array('url' => 'admin/user/search', 'class' => 'search_box', 'name'=>'frmSearch')) !!}
        <span class="search_label">           	
            {!! Form::text('q', null, array('class'=>'fip', 'placeholder'=>'Search...')) !!}
            {!! Form::submit('', array('class'=>'search_bgg')) !!}            
        </span>    
    {!! Form::close() !!}
@stop 

@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
        
            <h2 class="bedcrumb">
                <a href="{!! url('admin/dashboard') !!}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                   {!! $bredcrumb !!}                
            </h2>
            
            
           {!! Session::get('message') !!}
                                    
             <div class="button_right">  
             	                       	                  
                <a href="{!! url('admin/users/create') !!}" class="btn-green btn_hv">Create</a>	
                           
                <div class="btn-group">
                  	<div class="btn-black dropdown" data-toggle="dropdown" data-hover="dropdown"><i class="fa fa-chevron-down"></i>&nbsp;&nbsp;Action</div>
                      <ul class="dropdown-menu">
                            <li><a href="javascript:void(0);" onclick="return actionSubmit('users/updatestatus/1');">Activate</a></li>
                            <li><a href="javascript:void(0);" onclick="return actionSubmit('users/updatestatus/2');">Suspend</a></li>
                             <li><a href="javascript:void(0);" onclick="return actionSubmit('users/updatestatus/0');">Unverify</a></li>
                          
                            <li><a href="javascript:void(0);" onclick="return actionConfirm('<?php echo url('admin/users/delete'); ?>','Delete' );">Delete</a></li>
                            
                      </ul>
                 </div>
                 
                          
             </div>
             
             <div class="button_left">	
                <div class="btn-group">
                  <button class="btn-none" data-toggle="dropdown" data-hover="dropdown">Status&nbsp;&nbsp;<i class="fa fa-chevron-down"></i></button>
                  <ul class="dropdown-menu2">
                    <li><a href="{!! URL::to('admin/user') !!}">Any</a></li>
                    <li><a href="{!! URL::to('admin/user/status', array('status'=>2)) !!}">Suspended</a></li>
                    <li><a href="{!! URL::to('admin/user/status', array('status'=>1)) !!}">Active</a></li>
                    <li><a href="{!! URL::to('admin/user/status', array('status'=>0)) !!}">Unverified</a></li>
                  </ul>
                </div> 
             </div>	                          
            
            {!! $models->links() !!}
            
            

            <div class="table_holder">
            	{!! Form::open(array('id' => 'frmListing')) !!}
                    <table width="100%" border="0" cellspacing="1" cellpadding="0"  align="left" class="table" id="sortable" >
                         <tr class="row1 nodrop nodrag" >                         	
                            <td class="hd_td">Firstname</td>                                                   
                            <td class="hd_td">Created</td>
                            <td class="hd_td">Updated</td>
                            <td class="hd_td">Status</td>
                            <td class="hd_td">{!! Form::checkbox('toggle_check', '', '', array('onclick'=>'toggleSelect();')); !!}</td>
                         </tr>
            			
                         <?php $i = 0;?>
                         @foreach ($models as $m)
                             <tr class="{!! ($i%2==0) ? 'row2' : 'row1' !!}" id="{!! $m->id !!}">                             	 
                                 <td>{!! $m->first_name !!}<a href="{!! route('users.edit', $m->id) !!}"><i class="fa fa-pencil fa_icon"></i></a></td>
                                 <td>{!! $m->created_at !!}</td>
                                 <td>{!! $m->updated_at !!}</td>
                               <td>{!! $status[$m->status] !!}</td>					
                                 <td>{!! Form::checkbox('ids[]', $m->id) !!}</td>
                             </tr>
                             <?php $i++;?>
                         @endforeach 

                          
                    </table>
                {!! Form::close() !!}
                @if(sizeof($models)==0) 
                	
                @endif                
            </div>
            
            {!! $models->links() !!} 
            
           
        </div>
        <div class="marg10"></div>
    </aside>
@stop

