@extends('admin.layout')

@section('head')
 @parent
    <link href="{{asset('public/admin/smartmenu/sm-blue.css')}}" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="{{asset('public/admin/smartmenu/jquery.smartmenus.js')}}"></script>
    <script type="text/javascript">
        $(function() {
            $('#main-menu').smartmenus({
                subMenusSubOffsetX: 1,
                subMenusSubOffsetY: -20
            });
        });
    </script>
@stop

@section('search')      
    {!! Form::open(array('url' => 'admin/page/search', 'class' => 'search_box', 'name'=>'frmSearch')) !!}
        <span class="search_label">             
            {!! Form::text('q', null, array('class'=>'fip', 'placeholder'=>'Search...')) !!}
            {!! Form::submit('', array('class'=>'search_bgg')) !!}            
        </span>    
    {!! Form::close() !!}
@stop 

<meta name="csrf-token" content="{{ csrf_token() }}">


@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
        
            <h2 class="bedcrumb">
                <a href="{!! url('admin/dashboard') !!}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                  {!! $bredcrumb !!}              
            </h2>
            
            
           {!! Session::get('message') !!}
                                    
             <div class="button_right"> 
                <a href="{!! url('admin/pages/create') !!}" class="btn-green btn_hv">Create</a>                  
                <a href="javascript:void(0);" onclick="return actionConfirm('<?php echo url('admin/pages/delete'); ?>', 'Delete');" class="btn-red btn_hv">Delete</a>                                           
                 
             </div>

            <div class="button_left">

                <div class="button_mult">
                    <ul id="main-menu" class="sm sm-blue">
                        <li><a href="javascript:void(0);">Parent&nbsp;&nbsp;<i class="fa fa-chevron-down"></i></a>
                             {!! TreeHelper::menuAdmin('pages', 0, 'admin/pages') !!}
                        </li>
                    </ul>
                </div>

            </div>
                                                      
            
       <!--      {!! $models->links() !!} -->

            <div class="table_holder">
                {!! Form::open(array('id' => 'frmListing', 'method'=>'delete')) !!}
                <table width="100%" border="0" cellspacing="1" cellpadding="0"  align="left" class="table" id="sortable" >
                    <tr class="row1 nodrop nodrag" >
                            <td class="hd_td">Title</td>
                                <!-- <td class="hd_td">Slug</td>  -->
                             <td class="hd_td">Gallery</td>
                             <td class="hd_td">Childs</td>
                             <td class="hd_td">Move</td>
                             <td class="hd_td">Created</td>
                            <td class="hd_td">Updated</td>
                            <td class="hd_td">{!! Form::checkbox('toggle_check', '', '', array('onclick'=>'toggleSelect();')); !!}</td>
                         </tr>

                        <?php $sort_orders = '';?>
                         <?php $i = 0;?>
                         @foreach ($models as $m)
                            <?php $sort_orders.=$m->sort_order.',';?>
                             <tr class="{!! ($i%2==0) ? 'row2' : 'row1'!!}" id="{!! $m->id !!}">                                
                                 <td>{!! $m->title !!}<a href="{!! route('pages.edit', $m->id) !!}"><i class="fa fa-pencil fa_icon"></i></a></td>
                                                            
                                 <!--    <td>{!! $m->slug !!}</td> -->
                               
                                 <td><a href="{!! URL::to('admin/page-gallery/page', array('id'=>$m->id)) !!}"><i class="fa fa-picture-o fa_icon"> {!! $m->gallery->count() !!}</i></a></td>

                                 <td><a href="{!! route('pages.show', $m->id) !!}"><i class="fa fa-folder-open fa_icon">{!! $m->childs->count() !!}</i></a></td>
                                 <td class="move"><i class="fa fa-hand-o-up fa_icon"></i></td>
                                 <td>{!! $m->created_at !!}</td>
                                 <td>{!! $m->updated_at !!}</td>              
                                <td>{!! Form::checkbox('ids[]', $m->id) !!}</td>
                               
                                
                             </tr>
                             <?php $i++;?>
                         @endforeach 
                         
        {!! $models->links() !!} 
                          
                    </table>
                {!! Form::close() !!}
                @if(sizeof($models)==0) 
                   {!! NO_RECORD !!}
                @endif                
            </div>
          <!-- {!! $models->links() !!}  -->
            
           
        </div>
        <div class="marg10"></div>
    </aside>
@stop

@section('foot')
    @parent
    <script src="{{asset('public/admin/js/jquery.tablednd_0_5.js')}}" type="text/javascript"></script>
    <script type="text/javascript">
    
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
    
        $(document).ready(function(){
            $('#sortable').tableDnD({
                onDrop: function(table, row) {
                    //alert($.tableDnD.serialize());
                    $.post("ajax/drag-drop-sorting", {ids_order: $.tableDnD.serialize(), sort_orders:'<?php echo $sort_orders;?>', table:'pages' } );
                }
            });
        });
    </script>
@stop
