@extends('admin.layout')

@section('head')
    @parent
    <script type="text/javascript" src="../xtras/ckeditor/ckeditor.js"></script>
@stop

@section('content')
    <aside class="right_box">
        <h1 class="heading_inner">
            {!! $title !!}
            @include('admin.include.welcome')
        </h1>
        <!-- inside box -->
        <div class="right_inside">
            <h2 class="bedcrumb">
                <a href="{!! url('admin/dashboard') !!}"><i class="fa fa-home"></i>&nbsp;&nbsp;Dashboard</a>
                 {!! $bredcrumb !!}  
                                
            </h2>
        
   @if( isset($model) )
   {!! Form::model($model, ['method' => 'PATCH','route' => ['banners.update', $model->id], 'files' => true ]) !!}

@else
    {!! Form::open(['route' => 'banners.store', 'files' => true ]) !!}
@endif

                <!-- left form -->
                <aside class="Form_box_left">
                <div class="insed_form">
                    <h1 class="form_head">Enter Details</h1>
                    <ul class="form_ul">
                        
                        <li>
                            <ul class="tw35">
                                <li>Title <span class="req">*</span></li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>                                	
                                    {!! Form::text('title', null, array('class'=>'fip')) !!}
        							{!! $errors->first('title', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                                                
                        @if (isset($model) && $model->image)
                            <li>
                                <ul class="tw35">
                                    <li>Image</li>
                                </ul>

                                <ul class="tw65">
                                    <li>
                                        <img src="{!! asset($model->thumb.$model->image) !!}" alt="{!! $model->title !!}" class="image_list" />
                                    </li>
                                </ul>
                            </li>
                        @endif


                        <li>
                            <ul class="tw35">
                                <li>
                                	Upload Image 
                                	@if (!isset($model))
                                    	<span class="req">*</span>
                                    @endif
                                	<br><span>size : 555px * 270px (jpg, png, gif)</span>
                                </li>
                            </ul>
                            
                            <ul class="tw65">
                                <li>
                                	{!! Form::file('image', array('class'=>'fip2')) !!}
                                    {!! $errors->first('image', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>

                        <li>
                            <div class="editor_box">
                                {!! Form::textarea('content', null, array('class'=>'ckeditor')) !!}
                                {!! $errors->first('content', '<div class="err">:message</div>') !!}
                            </div>
                        </li>

                        <li>
                            <ul class="tw35">
                                <li>Url</li>
                            </ul>

                            <ul class="tw65">
                                <li>
                                    {!! Form::text('url', null, array('class'=>'fip', 'id'=>'url', 'onkeyup'=>'toggleTarget(this.value);')) !!}
        							{!! $errors->first('url', '<div class="err">:message</div>') !!}
                                </li>
                            </ul>
                        </li>
                                           
                        
                    </ul>	
                </div>    
                </aside>
                
                <!-- right form -->
                <aside class="Form_box_right">
                <div class="insed_form">
                    <ul class="form_ul2">
                        <h1 class="form_head">Status</h1>
                        <li>                            	
                            {!!
                                Form::select('status', array(
                                    '1' => 'Active', 
                                    '0' => 'Inactive'
                                    ),null,array('class'=>'fsl')
                                 )
                           !!}
                        </li>
                        <div id="target_section">
                            <h1 class="form_head">

                                    <span class="checkkkk">{!! Form::radio('target', 1) !!}  Yes</span>
                                    <span class="checkkkk">{!! Form::radio('target', 0, true) !!}  No</span>
                                    <span class="checkkkk"> </span>
                            </h1>
                        </div>
                        
                        <li class="last_li_form">
                        	{!! isset($model) ? Form::submit('Update', array('class'=>'fbt')) : Form::submit('Create', array('class'=>'fbt')) !!}
                        	
                        </li>
                        
                    </ul>
                        
                </div> 	
                </aside>
            {!! Form::close() !!}
        </div>
        
    </aside>
@stop

@section('foot')
    <script type="text/javascript">
        var url = document.getElementById('url').value;
        if(url=='')document.getElementById('target_section').style.display='none';
        else document.getElementById('target_section').style.display='inline';
        function toggleTarget(url)
        {
            if(url=='')document.getElementById('target_section').style.display='none';
            else document.getElementById('target_section').style.display='inline';
        }
    </script>
@stop