<?php
class CustomValidator extends Illuminate\Validation\Validator 
{
    public function validateExtensions($attribute, $value, $parameters)
    {
		if ($value->isValid() && $value->getPath() != '')
		{
			return in_array($value->getClientOriginalExtension(), $parameters);
		}
    }
	
	protected function replaceExtensions($message, $attribute, $rule, $parameters)
	{
		return str_replace(':values', implode(', ', $parameters), $message);
	}
	
	

}