<?php

namespace App\Models;
use App\Models\Country;
use Image;
use File;
use Illuminate\Support\Facades\Input;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Testimonial extends Model
{
     protected $table = 'testimonials';	
	protected $guarded = array('id', 'image', 'post_id', 'delete_image', 'created_at', 'updated_at');
	public $upload=	'public/uploads/testimonials/';
	public $thumb=	'public/uploads/testimonials/thumbs/';
	
	public function posts()
    {
        return $this->belongsToMany('App\Models\Post');
    }

		public function posts_testimonials()
    {
        return $this->belongsToMany('App\Models\Post', 'post_testimonial');
    }

	public function country()
    {
       return $this->belongsTo('App\Models\Country');
    }

	public static function createModel()
	{

		$model = new Testimonial(Input::all());	
		if (Input::hasFile('image'))
		{			
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(110, 110)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
	// dd(Input::all());
		$model->slug = Str::slug(Input::get('name'));						
		$model->save();	
			// dd(array(Input::get('post_id'));
		// dd($model->posts_testimonials());
		$model->posts_testimonials()->sync(Input::get('post_id'));
	}
	
	public static function updateModel($id)
	{		
			$inputs = Input::all();			
		$model = Testimonial::find($id);
		$model->fill($inputs);
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete(public_path().'/'.$model->upload.$model->image);
				File::delete(public_path().'/'.$model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(110, 110)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
		else if(Input::get('delete_image'))
		{
			if($model->image)
			{
				File::delete(public_path().'/'.$model->upload.$model->image);
				File::delete(public_path().'/'.$model->thumb.$model->image);
			}
			$model->image = '';
		}
		$model->slug = Str::slug(Input::get('name'));
		$model->save();	
		$model->posts_testimonials()->sync(Input::get('post_id'));
	}

	public static function deleteModel() {
        $models = Testimonial::whereIn('id', Input::get('ids'))->get(array('image'));
        foreach ($models as $m) {
            File::delete(public_path() . '/' . $m->upload . $m->image);
            File::delete(public_path() . '/' . $m->thumb . $m->image);
            $m->posts()->detach();
        }
        return Testimonial::whereIn('id', Input::get('ids'))->delete();
    }
}
