<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use App\Models\Place;
use Image;
use File;
use Str;
use DbHelper;
class Place extends Model
{
   protected $table = 'places';	
	protected $guarded = array('id', 'image', 'created_at', 'updated_at', 'sort_order');
	public $upload=	'public/uploads/places/';
	public $thumb=	'public/uploads/places/thumbs/';
	
	public static function createModel()
	{
		$model = new Place(Input::all()) ;
		 if($file = Input::hasFile('image')) {
            
            $file = Input::file('image') ;
            
           $extension=Input::file('image')->getClientOriginalExtension();
           $image=Str::slug(Input::get('title')).time().'.'.$extension;
            Input::file('image')->move($model->upload, $image);

     if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->resize(250, 160)->save($model->thumb.$image);
			}

            $model->image = $image;
		}
		$model->sort_order = DbHelper::nextSortOrder($model->table);						
		$model->save();	
	}
	
	public static function updateModel($id)
	{		
		$inputs = Input::all();			
		$model = Place::find($id);
		$model->fill($inputs);
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->resize(250, 160)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
		else if(Input::get('delete_image'))
		{
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$model->image = '';
		}
		$model->save();	
	}
	
	public static function deleteModel()
	{		
		$models=Banner::whereIn('id', Input::get('ids'))->get(array('image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return Banner::whereIn('id', Input::get('ids'))->delete();				
	}
}