<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use App\Models\Gallery;
use Image;
use File;
use Str;
use DbHelper;
class PageGallery extends Model
{
 protected $table = 'page_galleries';
	public $upload=	'public/uploads/page-galleries/';
	public $thumb=	'public/uploads/page_galleries/thumbs/';

	
	public function page()
    {
        return $this->belongsTo('App\Models\Page', 'parent_id');
    }
	

	public static function createModel($title, $image)
	{		
		$model = new PageGallery();
		$model->parent_id=Input::get('parent_id');
		$model->title=$title;
		$model->image=$image;	
		$model->status=Input::get('status');
		$model->sort_order = DbHelper::nextSortOrder($model->table);				
		$model->save();	
		
	}
	
	public static function updateModel()
	{		
			
		$model = PageGallery::find(Input::get('id'));
		
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete(public_path().'/'.$model->upload.$model->image);
				File::delete(public_path().'/'.$model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(200, 200)->save($model->thumb.$image);
			}
			$model->image = $image;
		}

		$model->title=Input::get('title');	
		$model->status=Input::get('status');		
		$model->save();					
	}
	
	public static function deleteModel()
	{				
		$models=PageGallery::whereIn('id', Input::get('ids'))->get(array('image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return PageGallery::whereIn('id', Input::get('ids'))->delete();
	}
	
	public static function deleteModelByParent($id)
	{	
		$models=PageGallery::where('parent_id', $id)->get(array('id', 'image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return PageGallery::where('parent_id', $id)->delete();
	}

	

	
}