<?php

namespace App\Models;
use Illuminate\Support\Facades\Input;
use Illuminate\Database\Eloquent\Model;
use Str;
use Image;
use File;
class Blog extends Model
{
    protected $table = 'blogs';
	protected $guarded = array('id', 'slug', 'image', 'delete_image', 'created_at', 'updated_at');
	public $upload=	'public/uploads/blogs/';
	public $thumb=	'public/uploads/blogs/thumbs/';

	
	public static function createModel()
	{
		$model = new Blog(Input::all());
		if (Input::hasFile('image'))
		{			
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
                Image::make($model->upload.$image)->fit(230, 144)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
       $model->slug = Str::slug(Input::get('title'));
		$model->save();	
	}
	
	public static function updateModel($id)
	{		
		$inputs = Input::all();			
		$model = Blog::find($id);
		$model->fill($inputs);
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
                Image::make($model->upload.$image)->fit(230, 144)->save($model->thumb.$image);
			}
			$model->image = $image;
		}
		else if(Input::get('delete_image'))
		{
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$model->image = '';
		}
        $model->slug = Str::slug(Input::get('title'));
		$model->save();	

	}
	
	public static function deleteModel()
	{		
		$models=Blog::whereIn('id', Input::get('ids'))->get(array('id', 'image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
		}
		return Blog::whereIn('id', Input::get('ids'))->delete();
	}

}