<?php

namespace App\Models;
use DbHelper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;
use App\Models\Gallery;
use Image;
use File;
class Album extends Model
{
    protected $table = 'albums';	
	protected $guarded = array('id', 'slug', 'created_at', 'updated_at', 'sort_order');
	public $upload=	'public/uploads/albums/';
	public $thumb=	'public/uploads/albums/thumbs/';	
	
	public function gallery()
    {
        return $this->hasMany('App\Models\Gallery' , 'parent_id');
    }
	
	public static function createModel()
	{
		 $model = new Album(Input::all()) ;
    
         if($file = Input::hasFile('image')) {
            
            $file = Input::file('image') ;
           
           $extension=Input::file('image')->getClientOriginalExtension();
           $image=Str::slug(Input::get('title')).time().'.'.$extension;
            Input::file('image')->move($model->upload, $image);

     if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(350, 263)->save($model->thumb.$image);
			}

            $model->image = $image;
		}	
$model->slug = Str::slug(Input::get('title'));
		$model->sort_order = DbHelper::nextSortOrder($model->table);				
		$model->save();	
	}
	
	public static function updateModel($id)
	{	

	    $inputs = Input::all();		
		$model = Album::find($id);	
		
		// $model = Album::find(Input::get('id'));
		$model->fill($inputs);
		if (Input::hasFile('image'))
		{	
			if($model->image)
			{
				File::delete($model->upload.$model->image);
				File::delete($model->thumb.$model->image);
			}
			$extension=Input::file('image')->getClientOriginalExtension();
			$image=Str::slug(Input::get('title')).time().'.'.$extension;
			Input::file('image')->move($model->upload, $image);
			if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
			{
				Image::make($model->upload.$image)->fit(350, 263)->save($model->thumb.$image);
			}
			$model->image = $image;
		}

		$model->slug = Str::slug(Input::get('title'));
		$model->save();	
	}
	
	public static function deleteModel()
	{		
		$models=Album::whereIn('id', Input::get('ids'))->get(array('image'));
		foreach($models as $m)
		{
			File::delete(public_path().'/'.$m->upload.$m->image);
			File::delete(public_path().'/'.$m->thumb.$m->image);
			Gallery::deleteModelByParent($m->id);
		}
		return Album::whereIn('id', Input::get('ids'))->delete();				
	}
}