<?php

namespace App\Models;

use App\Models\Country;
use App\Models\AdmimUser;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Input;
use Str;
use Hash;
use Image;
use File;
class AdminUser extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table = 'users';
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    
    protected $guarded = array('id', 'email', 'password', 'password_confirmation', 'image', 'delete_image', 'created_at', 'updated_at');
    public $upload= 'public/uploads/users/';
    public $thumb=  'public/uploads/users/thumbs/';

    /**
     * Get the unique identifier for the user.
     *
     * @return mixed
     */
    public function getAuthIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Get the password for the user.
     *
     * @return string
     */
    public function getAuthPassword()
    {
        return $this->password;
    }

    /**
     * Get the e-mail address where password reminders are sent.
     *
     * @return string
     */
    public function getReminderEmail()
    {
        return $this->email;
    }
    
    
    
    
    
    
    //custom codes ----------------------------------------------------------------------------------------------
   public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }
    
    public function posts()
    {
        return $this->hasMany('App\Models\Post' , 'author_id');
    }
    
    public function comments()
    {
        return $this->hasMany('App\Models\Comment');
    }
    
    
    public static function createModel()
    {
        $model = new AdminUser(Input::all()) ;
    
         if($file = Input::hasFile('image')) {
            
            $file = Input::file('image') ;          
            $extension=Input::file('image')->getClientOriginalExtension();
            $image=Str::slug(Input::get('first_name')).time().'.'.$extension;
            Input::file('image')->move($model->upload, $image);
            if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
            {
                Image::make($model->upload.$image)->fit(200, 200)->save($model->thumb.$image);
            }
            $model->image = $image;
        }
      // $model->slug = Str::slug(Input::get('title'));
        $model->password = Hash::make(Input::get('password'));
                    
        $model->save(); 
    }
    
    public static function updateModel()
    {       
       $inputs = Input::all();         
        $model = AdminUser::find($id);
        $model->fill($inputs);
        if (Input::hasFile('image'))
        {   
            if($model->image)
            
            {
                File::delete(public_path().'/'.$model->upload.$model->image);
                File::delete(public_path().'/'.$model->thumb.$model->image);
            }
            $extension=Input::file('image')->getClientOriginalExtension();
            $image=Str::slug(Input::get('title')).time().'.'.$extension;
            Input::file('image')->move($model->upload, $image);
            if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
            {
                Image::make($model->upload.$image)->fit(200, 200)->save($model->thumb.$image);
            }
            $model->image = $image;
        }
        else if(Input::get('delete_image'))
        {
            if($model->image)
            {
                File::delete(public_path().'/'.$model->upload.$model->image);
                File::delete(public_path().'/'.$model->thumb.$model->image);
            }
            $model->image = '';
        }
       $model->slug = Str::slug(Input::get('email'));
        if(Input::has('password'))$model->password = Hash::make(Input::get('password'));
        $model->save(); 
    }
    
    public static function deleteModel()
    {       
        $models=User::whereIn('id', Input::get('ids'))->get(array('image'));
        foreach($models as $m)
        {
            File::delete(public_path().'/'.$m->upload.$m->image);
            File::delete(public_path().'/'.$m->thumb.$m->image);
            Post::deleteModelByUser($m->id);
            Comment::deleteModelByUser($m->id);
        }
        return User::whereIn('id', Input::get('ids'))->delete();                
    }
    
    public function getRememberToken()
    {
        return $this->remember_token;
    }

    public function setRememberToken($value)
    {
        $this->remember_token = $value;
    }

    public function getRememberTokenName()
    {
        return 'remember_token';
    }
    }