<?php

namespace App\Http\Controllers\frontend;
use App\Models\SiteSetting;
use App\Models\Nav;
use App\Models\Banner;
use App\Models\Page;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Mail;
use Session;
use Validator;
use App\Models\Country;
use Redirect;
class ContactusController extends Controller
{
    //
    public function index(){

$data['site_setting'] = SiteSetting::all();

 $data['model'] = Page::orderBy('sort_order','asc')
    
            ->firstOrFail();
$data['meta_title'] = $data['model']->meta_title ? $data['model']->meta_title : $data['model']->title;
$data['meta_keywords'] = $data['model']->meta_keywords;
$data['meta_description'] = $data['model']->meta_description;

$data['countries'] =Country::orderBy('name','asc')->get();
    	return view('page.contactus', $data);
    }


    public function postContact(Request $request){

    	$rules=array(
            'name'=>'required',
            'contact_num'=>'required',
            'email' =>'required'
            );

        $validator=Validator::make($request->all(),$rules);
        $data  = array(
            'name'=> $request->name,
            'contact_num' => $request->contact_num,
            'country_id' => $request->country_id,
            'enquiry' => $request->enquiry,
            'email' => $request->email);
            
        Mail::send('emails.contact', $data, function($message) use($data){
            $message->from($data['email']);
            $message->to('menepaliramesh@gmail.com')->subject('Contact');
            // $message->napoklme($data['name']);
        });
        
        // Session::flash('success','Your Email Sent!');
        
        return Redirect::back()->with('message','<div class="error">Your online form has been submitted<br>Thank You for your Enquire about this trip, We will contact you very shortly....</div>');
    }
}
