<?php

namespace App\Http\Controllers;
use Session;
use Illuminate\Http\Request;
use Cache;
use App\Models\Post;
use App\Models\PostGallery;
class PostGalleryController extends Controller
{

    private $controller='admin/post-galleries';
    private $rpp=RPP;//row per page //default-RPP
    private $title='PostGallery';
    private $table='post_galleries';
    private $sort_by='sort_order';
    private $sort_order='asc';
    
    private $remember_page='post_gallery_parent_id';
    
    private $listing_page='admin.page.post_galleries';
    private $create_form='admin.page.post_gallery_a';
    private $update_form='admin.page.post_gallery_e';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                                        
    ); 
    public function __construct(){
$this->middleware('cadmin');
}              
    

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $data['title'] = $this->title;
        $data['status'] = $this->status;    
          
        //for return page
       
       $data['models'] = PostGallery::orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
      
        return View($this->listing_page, $data);
    
}
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
     $data['remember_page'] = $this->remember_page;        
        //bredcrumb
            
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
         
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = $this->title;
     
        $parent_model = Post::find(Cache::get($this->remember_page));
       $data['model'] = PostGallery::find($id); 
        return View($this->update_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
