<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PageGallery;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Redirect;
use Session;
use Cache;
use App\Models\Page;
use Helper;
use Str;
use Image;
class PageGalleryController extends Controller
{
    private $controller='admin/page-galleries';
    private $rpp=RPP;//row per page //default-RPP
    private $title='PageGallery';
    private $table='page_galleries';
    private $sort_by='sort_order';
    private $sort_order='asc';
    
    private $remember_page='page_gallery_parent_id';
    
    private $listing_page='admin.page.page-galleries';
    private $create_form='admin.page.page-gallery_a';
    private $update_form='admin.page.page-gallery_e';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                                        
    );
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $data['title'] = $this->title;
        $data['status'] = $this->status;        
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;
        
        $data['models'] = Page::with('gallery')
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);     
        return View($this->listing_page, $data);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getPage($id)
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;    
        
        //for return page
        Cache::forever($this->remember_page, $id);  
        
        $data['model'] = Page::find($id);
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to('admin/pages', 'Pages');
        $data['bredcrumb'].= ABS.$data['model']->title;
        
        $data['models'] = PageGallery::where('parent_id', $id)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View::make($this->listing_page, $data);
    }
    

    public function create()
    {
        $data['title'] = $this->title;
        $data['remember_page'] = $this->remember_page;
        
        $parent_model = Page::find(Cache::get($this->remember_page));
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to('admin/pages', 'Pages');
        // $data['bredcrumb'].= ABS.link_to($this->controller.'/pages/'.$parent_model->id, $parent_model->title);
        $data['bredcrumb'].= ABS.'Create';
        
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        foreach(Input::file('image') as $file)
        {
            $rules = array(
                'image' => 'required|mimes:jpeg,gif,png'
            );
            
            $validator = Validator::make(array('image'=> $file), $rules);
            if($validator->passes())
            {
                $extension = $file->getClientOriginalExtension();
                $title = trim(strip_tags(Helper::fileName($file->getClientOriginalName())));
                $image = Str::slug($title).time().'.'.$extension;
                $file->move('public/uploads/page-galleries/', $image);
                if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
                {
                    Image::make('public/uploads/page-galleries/'.$image)->fit(200, 200)->save('public/uploads/page-galleries/thumbs/'.$image);
                }
                                
                PageGallery::createModel($title, $image);

            }
            else
            {
                return Redirect::back()->withInput()->withErrors($validator);
            }

        }       
        return Redirect($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">'.CREATED.'</div>');
        
        
    }
    

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       $data['title'] = $this->title;
        
        $parent_model = Page::find(Cache::get($this->remember_page));
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to('admin/pages', 'Pages');
        $data['bredcrumb'].= ABS.link_to($this->controller.'/pages/'.$parent_model->id, $parent_model->title);
        $data['bredcrumb'].= ABS.'Update';              
                
        $data['model'] = PageGallery::find($id);
        return View::make($this->update_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
