<?php

namespace App\Http\Controllers;
use App\Models\Gallery;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Redirect;
use Illuminate\Http\Request;
use Session;
use Cache;
use App\Models\Album;
use Helper;
use Str;
use Image;
class GalleryController extends Controller
{
    private $controller='admin/galleries';
    private $rpp=RPP;//row per page //default-RPP
    private $title='Galleries';
    private $table='galleries';
    private $sort_by='sort_order';
    private $sort_order='asc';
    private $remember_page='gallery_parent_id';
    private $listing_page='admin.page.galleries';
    private $create_form='admin.page.gallery_a';
    private $update_form='admin.page.gallery_e';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>'                                        
    ); 
     public function __construct(){
$this->middleware('cadmin');
}            
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() 
    {
        $data['title'] = $this->title;
       $data['status'] = $this->status;     
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;
        
       
        $data['models'] = Gallery::orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    
}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getAlbum($id) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;    
        
        //for return page
        Cache::forever($this->remember_page, $id);  
        
        $data['model'] = Album::find($id);
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to('admin/albums', 'Albums');      
        $data['bredcrumb'].= ABS.$data['model']->title;
        
        $data['models'] = Gallery::where('parent_id', $id)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }

 public function status($status) 
    {
       $data['title'] = $this->title;
        $data['status'] = $this->status;        
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];
        
        $data['models'] = Gallery::where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    }

    public function create()
    {
       $data['title'] = $this->title;
        $data['remember_page'] = $this->remember_page;
        
        $parent_model = Album::find(Cache::get($this->remember_page));
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to('admin/albums', 'Albums');
        // $data['bredcrumb'].= ABS.link_to($this->controller.'/albums/'.$parent_model->id, $parent_model->title);
        $data['bredcrumb'].= ABS.'Create';
        
        return View($this->create_form, $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       foreach(Input::file('image') as $file)
        {
            $rules = array(
                'image' => 'required|mimes:jpeg,gif,png'
            );
            
            $validator = Validator::make(array('image'=> $file), $rules);
            if($validator->passes())
            {
                $extension = $file->getClientOriginalExtension();
                $title = trim(strip_tags(Helper::fileName($file->getClientOriginalName())));
                $image = Str::slug($title).time().'.'.$extension;
                $file->move('public/uploads/galleries/', $image);
                if(in_array(strtolower($extension), array('jpg','jpeg','gif','png')))
                {
                    Image::make('public/uploads/galleries/'.$image)->fit(350, 263)->save('public/uploads/galleries/thumbs/'.$image);
                }
                                
                Gallery::createModel($title, $image);

            }
            else
            {
                return Redirect::back()->withInput()->withErrors($validator);
            }

        }       
        return Redirect($this->controller.'/albums'.Cache::get($this->remember_page))->with('message','<div class="success">'.CREATED.'</div>');        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = $this->title;
        
        $parent_model = Album::find(Cache::get($this->remember_page));
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to('admin/album', 'Albums');
        $data['bredcrumb'].= ABS.link_to($this->controller.'/album/'.$parent_model->id, $parent_model->title);
        $data['bredcrumb'].= ABS.'Update';              
                
        $data['model'] = Gallery::find($id);
        return View($this->update_form, $data);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $rules = array(
            "title" => "required",
            "image" => "mimes:jpeg,gif,png",            
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        Gallery::updateModel();
            
        return Redirect($this->controller.'/'.Cache::get($this->remember_page))->with('message','<div class="success">1 '.UPDATED.'</div>');  

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     public function postUpdateStatus($status) 
    {       
        // dd(Input::all());
        $affected_models = Gallery::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }
    public function destroy()
    {
        $affected_models = Gallery::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.DELETED.'</div>');  
    }
}
