<?php

namespace App\Http\Controllers;
use App\Models\AdminUser;
use App\Models\User;
use Illuminate\Http\Request;
use Cache;
use App\Models\Country;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Redirect;
use Session;
class AdminController extends Controller
{

    private $controller='admin/admins';
    private $rpp=RPP;//row per page //default-RPP
    private $title='Admins';
    private $table='users';
    private $sort_by='first_name';
    private $sort_order='asc';
    
    private $listing_page='admin.page.admins';
    private $create_form='admin.page.admin_ae';
    private $update_form='admin.page.admin_ae';
    private $change_password_form='admin.page.change_password';
    
    private $status = array(
        '0'=>'<span class="red">Inactive</span>', 
        '1'=>'<span class="green">Active</span>',                                   
    );


public function __construct(){
$this->middleware('cadmin');
}    
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $data['title'] = $this->title;
        $data['status'] = $this->status;        
                
        //bredcrumb
        $data['bredcrumb'] = ABS.$this->title;
        
       
        $data['models'] = AdminUser::where('admin',1)
            ->where('dev', '!=', 1)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View($this->listing_page, $data);
    
}



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function status($status) 
    {
        $data['title'] = $this->title;
        $data['status'] = $this->status;        
        
        //bredcrumb     
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.$this->status[$status];
        
        $data['models'] = AdminUser::where('admin',1)
            ->where('dev', '!=', 1)
            ->where('status', $status)
            ->orderBy($this->sort_by, $this->sort_order)
            ->paginate($this->rpp);
        return View('admin.page.admins', $data);
    }
    public function create()
    {
       $data['title'] = $this->title;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Create';
        $data['countries'] = Country::all();
        return View($this->create_form, $data);
    }
    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $rules = array(
            "username" => "required|alpha_num|unique:".$this->table,
            "password" => "required|alpha_num|confirmed|min:6|max:18",
            "first_name" => "required",
            "image" => "mimes:jpeg,gif,png",
            "country_id" => "required",             
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        AdminUser::createModel();
        return Redirect($this->controller)->with('message','<div class="success">1 '.CREATED.'</div>');
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      $data['title'] = $this->title;
        
        //bredcrumb
        $data['bredcrumb'] = ABS.link_to($this->controller, $this->title);
        $data['bredcrumb'].= ABS.'Update';



        $data['model'] = User::where('id',$id)
            ->where('dev','!=',1)
            ->firstOrFail();
        return View($this->update_form, $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        $rules = array(
            "username" => "required|alpha_num|unique:".$this->table.",username,".Input::get('id'),
            "password" => "alpha_num|confirmed|min:6|max:18",
            "first_name" => "required",
            "image" => "mimes:jpeg,gif,png",
            "country_id" => "required",             
        );
        
        $validator = Validator::make(Input::all(),$rules);      
        if ($validator->fails())
        {
            return Redirect::back()->withInput()->withErrors($validator);
        }
        
        
        AdminUser::updateModel($id);
        return Redirect($this->controller)->with('message','<div class="success">1 '.UPDATED.'</div>');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function postUpdateStatus($status) 
    {       
        
        $affected_models = User::whereIn('id', Input::get('ids'))->update(array('status' => $status));
        return Redirect::back()->with('message', '<div class="success">'.$affected_models.' '.UPDATED.'</div>');        
    }
    public function destroy($id)
    {
        $affected_models = User::deleteModel();
        return Redirect::back()->with('message','<div class="success">'.$affected_models.' '.DELETED.'</div>'); 
    }
}

